/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.PrivateException;
import com.sun.tools.jmake.PublicExceptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Utils {
    static final String REPORT_PROBLEM = "Please report this problem to Mikhail.Dmitriev@sun.com";
    static final byte[] MAGIC = new byte[]{74, 97, 118, 97, 109, 97, 107, 101, 32, 80, 114, 111, 106, 101, 99, 116, 32, 68, 97, 116, 97, 98, 97, 115, 101, 32, 70, 105, 108, 101};
    static final int magicLength = MAGIC.length;
    static final int PDB_FORMAT_CODE_OLD = 1;
    static final int PDB_FORMAT_CODE_133 = 0x1030300;
    static final int PDB_FORMAT_CODE_LATEST = 0x1030300;
    static final int JAVAC_TARGET_RELEASE_OLDEST = 0x1040000;
    static final int JAVAC_TARGET_RELEASE_15 = 0x1050000;
    static final int JAVAC_TARGET_RELEASE_16 = 0x1060000;
    static final int JAVAC_TARGET_RELEASE_17 = 0x1070000;
    static final int JAVAC_TARGET_RELEASE_18 = 0x1080000;
    static int warningLimit = 20;
    static final int TIMING_TOTAL = 0;
    static final int TIMING_PDBREAD = 1;
    static final int TIMING_SYNCHRO = 2;
    static final int TIMING_SYNCHRO_CHECK_JAVA_FILES = 3;
    static final int TIMING_FIND_UPDATED_JAVA_FILES = 4;
    static final int TIMING_CLASS_FILE_OBSOLETE_OR_DELETED = 5;
    static final int TIMING_COMPILE = 6;
    static final int TIMING_FIND_UPDATED_CLASSES = 7;
    static final int TIMING_CHECK_UPDATED_CLASSES = 8;
    static final int TIMING_PDBWRITE = 9;
    static final int TIMING_SYNCHRO_CHECK_TMP = 10;
    static final int TIMING_CLASS_FILE_OBSOLETE_TMP = 11;
    static final int TIMING_PDBUPDATE = 12;
    static final int TIMING_ARRAY_LENGTH = 13;
    private static long[] timings = new long[13];
    private static boolean timingOn = false;
    private static PrintStream out = System.out;
    private static PrintStream warn = System.out;
    private static PrintStream err = System.err;
    private static boolean printInfoMessages = true;
    private static boolean printWarningMessages = true;
    private static boolean printErrorMessages = true;
    private static int warningNo;

    public static String getPackageName(String clazzName) {
        int ldi = clazzName.lastIndexOf(47);
        if (ldi == -1) {
            return "";
        }
        return clazzName.substring(0, ldi).intern();
    }

    public static String getDirectlyEnclosingClass(String clazzName, int javacTargetRelease) {
        int ldi = clazzName.lastIndexOf(36);
        if (ldi == -1) {
            return "";
        }
        if (javacTargetRelease >= 0x1050000) {
            return clazzName.substring(0, ldi).intern();
        }
        int lldi = clazzName.lastIndexOf(36, ldi - 1);
        if (lldi == -1 || !Character.isDigit(clazzName.charAt(lldi + 1))) {
            return clazzName.substring(0, ldi).intern();
        }
        return clazzName.substring(0, lldi).intern();
    }

    public static String getTopLevelEnclosingClass(String clazzName) {
        int fdi = clazzName.indexOf(36);
        if (fdi == -1) {
            return "";
        }
        return clazzName.substring(0, fdi).intern();
    }

    public static String getClassFileFullPathForNestedClass(String enclosingClassFileFullPath, String nestedClassFullName) {
        String enclosingClassDir = enclosingClassFileFullPath;
        int cutIndex = enclosingClassDir.lastIndexOf(File.separatorChar);
        enclosingClassDir = enclosingClassDir.substring(0, cutIndex + 1);
        cutIndex = nestedClassFullName.lastIndexOf(47);
        String nestedClassLocalName = cutIndex < 0 ? nestedClassFullName : nestedClassFullName.substring(cutIndex + 1);
        return String.valueOf(enclosingClassDir) + nestedClassLocalName + ".class";
    }

    public static boolean sameParamNumber(String sig1, String sig2) {
        return Utils.getParamNumber(sig1) == Utils.getParamNumber(sig2);
    }

    /*
     * Unable to fully structure code
     */
    private static int getParamNumber(String sig) {
        parNo = 0;
        pos = 0;
        do {
            if ((ch = sig.charAt(++pos)) != ')') ** GOTO lbl7
            break;
lbl-1000:
            // 1 sources

            {
                ch = sig.charAt(++pos);
lbl7:
                // 2 sources

                ** while (ch == '[')
            }
lbl8:
            // 1 sources

            ++parNo;
            if (ch != '@') continue;
            while (ch != '#') {
                ch = sig.charAt(++pos);
            }
        } while (ch != ')');
        return parNo;
    }

    public static File checkFileForName(String name) {
        if (name == null) {
            return null;
        }
        File file = new File(name);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static File checkOrCreateDirForName(String name) {
        File file = new File(name);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new PrivateException(new PublicExceptions.InternalException(file + " is not a directory."));
            }
            return file;
        }
        return null;
    }

    public static byte[] readFileIntoBuffer(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            int len = (int)file.length();
            return Utils.readInputStreamIntoBuffer(in, len);
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
    }

    public static byte[] readZipEntryIntoBuffer(ZipFile file, ZipEntry entry) {
        try {
            InputStream in = file.getInputStream(entry);
            int len = (int)entry.getSize();
            return Utils.readInputStreamIntoBuffer(in, len);
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
    }

    public static byte[] readInputStreamIntoBuffer(InputStream in, int len) throws IOException {
        int readBytes;
        byte[] buf = new byte[len];
        int ofs = 0;
        int remBytes = len;
        do {
            readBytes = in.read(buf, ofs, remBytes);
            remBytes -= readBytes;
        } while ((ofs += readBytes) < len);
        in.close();
        return buf;
    }

    public static void readAndPrintBytesFromStream(InputStream in, OutputStream out) throws IOException {
        int avail = in.available();
        if (avail > 0) {
            byte[] outbytes = new byte[avail];
            int realOutBytes = in.read(outbytes);
            out.write(outbytes, 0, realOutBytes);
        }
    }

    public static String convertDriveLetterToLowerCase(String path) {
        if (path.charAt(1) != ':') {
            return path;
        }
        char drive = path.charAt(0);
        if (Character.isUpperCase(drive)) {
            drive = Character.toLowerCase(drive);
            char[] chars = path.toCharArray();
            chars[0] = drive;
            path = new String(chars);
        }
        return path;
    }

    public static void ignore(Exception e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delay(int ms) {
        Object o;
        Object object = o = new Object();
        synchronized (object) {
            try {
                o.wait(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void setOutputStreams(PrintStream out, PrintStream warn, PrintStream err) {
        Utils.out = out;
        Utils.warn = warn;
        Utils.err = err;
    }

    public static void customizeOutput(boolean printInfoMessages, boolean printWarningMessages, boolean printErrorMessages) {
        Utils.printInfoMessages = printInfoMessages;
        Utils.printWarningMessages = printWarningMessages;
        Utils.printErrorMessages = printErrorMessages;
    }

    public static void printInfoMessage(String message) {
        if (printInfoMessages) {
            out.println(message);
        }
    }

    public static void printInfoMessageNoEOL(String message) {
        if (printInfoMessages) {
            out.print(message);
        }
    }

    public static void printWarningMessage(String message) {
        if (!printWarningMessages) {
            return;
        }
        if (warningNo < warningLimit) {
            warn.println(message);
        } else if (warningNo == warningLimit) {
            warn.println("jmake: more than " + warningLimit + " warnings.");
        }
        ++warningNo;
    }

    public static void printErrorMessage(String message) {
        if (printErrorMessages) {
            err.println("jmake: " + message);
        }
    }

    public static void setTimingOn() {
        timingOn = true;
    }

    public static void startTiming(int slot) {
        Utils.timings[slot] = System.currentTimeMillis();
    }

    public static void stopAndPrintTiming(String message, int slot) {
        if (timingOn) {
            long time = System.currentTimeMillis() - timings[slot];
            Utils.printInfoMessage("========== " + message + " time = " + time);
        }
    }

    public static void printTiming(String message, int slot) {
        if (timingOn) {
            Utils.printInfoMessage("========== " + message + " time = " + timings[slot]);
        }
    }

    public static void stopAndAddTiming(int slot1, int slot2) {
        if (timingOn) {
            long time = System.currentTimeMillis() - timings[slot1];
            int n = slot2;
            timings[n] = timings[n] + time;
        }
    }
}

