/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake.ant;

import com.sun.tools.jmake.Main;
import com.sun.tools.jmake.Utils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class JavaMake
extends Javac {
    private static final String FAIL_MSG = "Compilation invoked by jmake failed, messages should have been provided.";
    private String pdbFilename;
    private boolean failOnDependentJar = false;
    private boolean noWarnOnDependentJar = false;
    protected List<String> sourceFileNameList;
    protected Path projClasspath;

    public String getPdbFilename() {
        return this.pdbFilename;
    }

    public void setPdbFilename(String v) {
        this.pdbFilename = v;
    }

    public void setProjClasspath(Path classpath) {
        if (this.projClasspath == null) {
            this.projClasspath = classpath;
        } else {
            this.projClasspath.append(classpath);
        }
    }

    public Path getProjClasspath() {
        return this.projClasspath;
    }

    public Path createProjClasspath() {
        if (this.projClasspath == null) {
            this.projClasspath = new Path(this.getProject());
        }
        return this.projClasspath.createPath();
    }

    public void setProjClasspathRef(Reference r) {
        this.createProjClasspath().setRefid(r);
    }

    public boolean getFailOnDependentJar() {
        return this.failOnDependentJar;
    }

    public void setFailOnDependentJar(boolean v) throws BuildException {
        if (v && this.noWarnOnDependentJar) {
            throw new BuildException("failOnDependentJar and noWarnOnDependentJar attributes can't be set to true together.");
        }
        this.failOnDependentJar = v;
    }

    public boolean getNoWarnOnDependentJar() {
        return this.noWarnOnDependentJar;
    }

    public void setNoWarnOnDependentJar(boolean v) throws BuildException {
        if (this.failOnDependentJar) {
            throw new BuildException("failOnDependentJar and noWarnOnDependentJar attributes can't be set to true together.");
        }
        this.noWarnOnDependentJar = v;
    }

    public void resetSourceFileNameList() {
        this.sourceFileNameList = new ArrayList<String>(100);
    }

    public String[] sourceFileNameListArray() {
        return this.sourceFileNameList.toArray(new String[this.sourceFileNameList.size()]);
    }

    public void execute() throws BuildException {
        this.resetSourceFileNameList();
        super.execute();
    }

    protected void scanDir(File srcDir, File destDir, String[] fileNames) {
        String srcDirName = srcDir.getAbsolutePath();
        if (srcDirName != null && !"".equals(srcDirName) && !srcDirName.endsWith(File.separator)) {
            srcDirName = String.valueOf(srcDirName) + File.separator;
        }
        int i = 0;
        while (i < fileNames.length) {
            if (fileNames[i].endsWith(".java")) {
                this.sourceFileNameList.add(String.valueOf(srcDirName) + fileNames[i]);
            }
            ++i;
        }
    }

    protected void compile() {
        Method compileSourceFilesMethod;
        if (this.sourceFileNameList.size() == 0) {
            return;
        }
        File destDir = this.getDestdir();
        Class<?> thisClass = ((Object)((Object)this)).getClass();
        try {
            Class[] args = new Class[]{String[].class};
            compileSourceFilesMethod = thisClass.getDeclaredMethod("compileSourceFiles", args);
        }
        catch (Exception e) {
            throw new BuildException(String.valueOf(e.getMessage()) + "\n Should not happen!");
        }
        String pdbFileName = this.getPdbFilename();
        if (pdbFileName == null) {
            pdbFileName = this.getProject().getProperty("jmake.pdb.filename");
        }
        File pdbFile = pdbFileName != null ? this.getProject().resolveFile(pdbFileName) : null;
        Main jmake = new Main();
        try {
            Path path;
            Path compilePath = this.getClasspath();
            if (compilePath != null) {
                Main.setClassPath(compilePath.toString());
            }
            if ((path = this.getProjClasspath()) != null) {
                Main.setProjectClassPath(path.toString());
            }
            if (compilePath == null) {
                compilePath = path;
            } else if (path != null) {
                compilePath.append(path);
            }
            this.setClasspath(compilePath);
            path = this.getBootclasspath();
            if (path != null) {
                Main.setBootClassPath(path.toString());
            }
            if ((path = this.getExtdirs()) != null) {
                Main.setExtDirs(path.toString());
            }
        }
        catch (Exception e) {
            Utils.ignore(e);
        }
        if (this.failOnDependentJar || this.noWarnOnDependentJar) {
            jmake.setResponseOnDependentJar(this.failOnDependentJar ? 2 : 0);
        }
        Main.setOutputStreams(System.out, System.out, System.err);
        int res = jmake.mainExternalControlled(this.sourceFileNameListArray(), destDir != null ? destDir.getAbsolutePath() : null, pdbFile != null ? pdbFile.getAbsolutePath() : null, (Object)this, compileSourceFilesMethod);
        if (res != 0) {
            if (this.failOnError) {
                throw new BuildException(FAIL_MSG, this.getLocation());
            }
            this.log(FAIL_MSG, 0);
        }
    }

    public int compileSourceFiles(String[] files) {
        int result;
        this.resetFileLists();
        this.compileList = new File[files.length];
        int i = 0;
        while (i < files.length) {
            this.compileList[i] = new File(files[i]);
            ++i;
        }
        boolean savedFailOnError = this.failOnError;
        this.failOnError = true;
        try {
            super.compile();
            result = 0;
        }
        catch (BuildException e) {
            Utils.ignore((Exception)((Object)e));
            this.log(FAIL_MSG, 0);
            result = -1;
        }
        this.failOnError = savedFailOnError;
        return result;
    }
}

