/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.withretry;

import java.io.PrintStream;
import java.lang.reflect.Method;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class BlockJUnit4ClassRunnerWithRetry
extends BlockJUnit4ClassRunner {
    private final int numRetries;
    private final PrintStream err;

    public BlockJUnit4ClassRunnerWithRetry(Class<?> klass, int numRetries, PrintStream err) throws InitializationError {
        super(klass);
        this.numRetries = numRetries;
        this.err = err;
    }

    protected Statement createStatement(FrameworkMethod method) {
        return super.methodBlock(method);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        return new InvokeWithRetry(method);
    }

    private class InvokeWithRetry
    extends Statement {
        private final FrameworkMethod method;

        public InvokeWithRetry(FrameworkMethod method) {
            this.method = method;
        }

        public void evaluate() throws Throwable {
            Throwable error = null;
            for (int i = 0; i <= BlockJUnit4ClassRunnerWithRetry.this.numRetries; ++i) {
                try {
                    BlockJUnit4ClassRunnerWithRetry.this.createStatement(this.method).evaluate();
                    if (i > 0) {
                        Method m = this.method.getMethod();
                        String testName = m.getName() + '(' + m.getDeclaringClass().getName() + ')';
                        BlockJUnit4ClassRunnerWithRetry.this.err.println("Test " + testName + " is FLAKY; passed after " + (i + 1) + " attempts");
                    }
                    return;
                }
                catch (Throwable t) {
                    if (t instanceof Exception || t instanceof AssertionError) {
                        if (error != null) continue;
                        error = t;
                        continue;
                    }
                    throw t;
                }
            }
            throw error;
        }
    }
}

