/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.withretry;

import java.io.PrintStream;
import java.lang.reflect.Method;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class BlockJUnit4ClassRunnerWithRetry
extends BlockJUnit4ClassRunner {
    private final int numRetries;
    private final PrintStream err;

    public BlockJUnit4ClassRunnerWithRetry(Class<?> clazz, int n, PrintStream printStream) throws InitializationError {
        super(clazz);
        this.numRetries = n;
        this.err = printStream;
    }

    protected Statement createStatement(FrameworkMethod frameworkMethod) {
        return super.methodBlock(frameworkMethod);
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        return new InvokeWithRetry(frameworkMethod);
    }

    private class InvokeWithRetry
    extends Statement {
        private final FrameworkMethod method;

        public InvokeWithRetry(FrameworkMethod frameworkMethod) {
            this.method = frameworkMethod;
        }

        public void evaluate() throws Throwable {
            Throwable throwable = null;
            for (int i = 0; i <= BlockJUnit4ClassRunnerWithRetry.this.numRetries; ++i) {
                try {
                    BlockJUnit4ClassRunnerWithRetry.this.createStatement(this.method).evaluate();
                    if (i > 0) {
                        Method method = this.method.getMethod();
                        String string = method.getName() + '(' + method.getDeclaringClass().getName() + ')';
                        BlockJUnit4ClassRunnerWithRetry.this.err.println("Test " + string + " is FLAKY; passed after " + (i + 1) + " attempts");
                    }
                    return;
                }
                catch (Throwable throwable2) {
                    if (throwable2 instanceof Exception || throwable2 instanceof AssertionError) {
                        if (throwable != null) continue;
                        throwable = throwable2;
                        continue;
                    }
                    throw throwable2;
                }
            }
            throw throwable;
        }
    }
}

