/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.io.PrintStream;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.pantsbuild.tools.junit.impl.ConsoleListener;
import org.pantsbuild.tools.junit.impl.Util;

class PerTestConsoleListener
extends ConsoleListener {
    private final PrintStream out;

    PerTestConsoleListener(PrintStream printStream) {
        super(printStream);
        this.out = printStream;
    }

    public void testRunStarted(Description description) throws Exception {
        String string = Util.getPantsFriendlyDisplayName(description);
        if (string != "null") {
            this.out.println(string);
        }
    }

    public void testStarted(Description description) {
        this.out.print("\t" + Util.getPantsFriendlyDisplayName(description));
    }

    public void testFinished(Description description) throws Exception {
        this.out.println();
    }

    @Override
    public void testFailure(Failure failure) {
        this.out.println(" -> FAILED");
    }
}

