/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

final class Util {
    private Util() {
    }

    static boolean isIgnored(Description description) {
        return description.getAnnotation(Ignore.class) != null;
    }

    static boolean isRunnable(Description description) {
        return description.isTest() && !Util.isIgnored(description);
    }

    static boolean isAssertionFailure(Failure failure) {
        return failure.getException() instanceof AssertionError;
    }

    static String getPantsFriendlyDisplayName(Description description) {
        String string = description.getClassName();
        String string2 = description.getMethodName();
        String string3 = description.getDisplayName();
        if (string.equals(string3) || string2.equals(string3)) {
            return string3;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 1);
        stringBuffer.append(string);
        stringBuffer.append("#");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

