/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Test;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.pantsbuild.args4j.InvalidCmdLineArgumentException;
import org.pantsbuild.tools.junit.AbortableListener;
import org.pantsbuild.tools.junit.AnnotatedClassRequest;
import org.pantsbuild.tools.junit.AntJunitXmlReportListener;
import org.pantsbuild.tools.junit.ConcurrentCompositeRequest;
import org.pantsbuild.tools.junit.ConsoleListener;
import org.pantsbuild.tools.junit.ForwardingListener;
import org.pantsbuild.tools.junit.PerClassConsoleListener;
import org.pantsbuild.tools.junit.StreamSource;
import org.pantsbuild.tools.junit.Util;
import org.pantsbuild.tools.junit.withretry.AllDefaultPossibilitiesBuilderWithRetry;

public class ConsoleRunner {
    private static final SwappableStream<PrintStream> SWAPPABLE_OUT = new SwappableStream<PrintStream>(System.out);
    private static final SwappableStream<PrintStream> SWAPPABLE_ERR = new SwappableStream<PrintStream>(System.err);
    private static boolean callSystemExitOnFinish = true;
    private static int exitStatus;
    private static final Pattern METHOD_PARSER;
    private final boolean failFast;
    private final boolean suppressOutput;
    private final boolean xmlReport;
    private final File outdir;
    private final boolean perTestTimer;
    private final boolean defaultParallel;
    private final int parallelThreads;
    private final int testShard;
    private final int numTestShards;
    private final int numRetries;
    public static final Predicate<Constructor<?>> IS_PUBLIC_CONSTRUCTOR;
    private static final Predicate<Method> IS_ANNOTATED_TEST_METHOD;

    ConsoleRunner(boolean failFast, boolean suppressOutput, boolean xmlReport, boolean perTestTimer, File outdir, boolean defaultParallel, int parallelThreads, int testShard, int numTestShards, int numRetries) {
        this.failFast = failFast;
        this.suppressOutput = suppressOutput;
        this.xmlReport = xmlReport;
        this.perTestTimer = perTestTimer;
        this.outdir = outdir;
        this.defaultParallel = defaultParallel;
        this.parallelThreads = parallelThreads;
        this.testShard = testShard;
        this.numTestShards = numTestShards;
        this.numRetries = numRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(Iterable<String> tests) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        System.setOut(new PrintStream(SWAPPABLE_OUT));
        System.setErr(new PrintStream(SWAPPABLE_ERR));
        List<Request> requests = this.parseRequests(out, err, tests);
        if (this.numTestShards > 0) {
            requests = this.setFilterForTestShard(requests);
        }
        JUnitCore core = new JUnitCore();
        AbortableListener abortableListener = new AbortableListener(this.failFast){

            @Override
            protected void abort(Result failureResult) {
                ConsoleRunner.exit(failureResult.getFailureCount());
            }
        };
        core.addListener((RunListener)abortableListener);
        if (this.xmlReport || this.suppressOutput) {
            if (!this.outdir.exists() && !this.outdir.mkdirs()) {
                throw new IllegalStateException("Failed to create output directory: " + this.outdir);
            }
            StreamCapturingListener streamCapturingListener = new StreamCapturingListener(this.outdir);
            abortableListener.addListener(streamCapturingListener);
            if (this.xmlReport) {
                AntJunitXmlReportListener xmlReportListener = new AntJunitXmlReportListener(this.outdir, streamCapturingListener);
                abortableListener.addListener(xmlReportListener);
            }
        }
        if (this.perTestTimer) {
            abortableListener.addListener((RunListener)new PerClassConsoleListener(out));
        } else {
            core.addListener((RunListener)new ConsoleListener(out));
        }
        Thread abnormalExitHook = this.createAbnormalExitHook(abortableListener, out);
        Runtime.getRuntime().addShutdownHook(abnormalExitHook);
        int failures = 0;
        try {
            if (this.parallelThreads > 1) {
                ConcurrentCompositeRequest request = new ConcurrentCompositeRequest(requests, this.defaultParallel, this.parallelThreads);
                failures = core.run((Runner)request).getFailureCount();
            } else {
                for (Request request : requests) {
                    Result result = core.run(request);
                    failures += result.getFailureCount();
                }
            }
        }
        catch (InitializationError initializationError) {
            failures = 1;
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(abnormalExitHook);
        }
        ConsoleRunner.exit(failures);
    }

    private Thread createAbnormalExitHook(final AbortableListener listener, final PrintStream out) {
        Thread abnormalExitHook = new Thread(){

            @Override
            public void run() {
                try {
                    listener.abort(new UnknownError("Abnormal VM exit - test crashed."));
                }
                catch (Exception e) {
                    out.println(e);
                    e.printStackTrace(out);
                }
                out.println("FATAL: VM exiting uncleanly.");
                out.flush();
                Runtime.getRuntime().halt(1);
            }
        };
        return abnormalExitHook;
    }

    private List<Request> parseRequests(PrintStream out, PrintStream err, Iterable<String> specs) {
        class TestMethod {
            private final Class<?> clazz;
            private final String name;

            TestMethod(Class<?> clazz, String name) {
                this.clazz = clazz;
                this.name = name;
            }
        }
        LinkedHashSet testMethods = Sets.newLinkedHashSet();
        LinkedHashSet classes = Sets.newLinkedHashSet();
        for (String spec : specs) {
            Matcher matcher = METHOD_PARSER.matcher(spec);
            try {
                Class<?> testClass;
                if (matcher.matches()) {
                    testClass = this.loadClass(matcher.group(1));
                    if (!ConsoleRunner.isTest(testClass)) continue;
                    String method = matcher.group(2);
                    testMethods.add(new TestMethod(testClass, method));
                    continue;
                }
                testClass = this.loadClass(spec);
                if (!ConsoleRunner.isTest(testClass)) continue;
                classes.add(testClass);
            }
            catch (NoClassDefFoundError e) {
                this.notFoundError(spec, out, e);
            }
            catch (ClassNotFoundException e) {
                this.notFoundError(spec, out, e);
            }
            catch (LinkageError e) {
                this.notFoundError(spec, out, e);
            }
            catch (RuntimeException e) {
                this.notFoundError(spec, out, e);
            }
        }
        ArrayList requests = Lists.newArrayList();
        if (!classes.isEmpty()) {
            if (this.perTestTimer || this.parallelThreads > 1) {
                for (Class clazz : classes) {
                    requests.add(new AnnotatedClassRequest(clazz, this.numRetries, err));
                }
            } else {
                try {
                    AllDefaultPossibilitiesBuilderWithRetry builder = new AllDefaultPossibilitiesBuilderWithRetry(this.numRetries, err);
                    Runner suite = new Computer().getSuite((RunnerBuilder)builder, classes.toArray(new Class[classes.size()]));
                    requests.add(Request.runner((Runner)suite));
                }
                catch (InitializationError e) {
                    throw new RuntimeException("Internal error: Suite constructor, called as above, should always complete");
                }
            }
        }
        for (TestMethod testMethod : testMethods) {
            requests.add(new AnnotatedClassRequest(testMethod.clazz, this.numRetries, err).filterWith(Description.createTestDescription((Class)testMethod.clazz, (String)testMethod.name)));
        }
        return requests;
    }

    private Class<?> loadClass(String name) throws ClassNotFoundException {
        return Class.forName(name, false, this.getClass().getClassLoader());
    }

    private List<Request> setFilterForTestShard(List<Request> requests) {
        class TestFilter
        extends Filter {
            private int testIdx;
            private HashMap<String, Boolean> testToRunStatus = new HashMap();

            TestFilter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean shouldRun(Description desc) {
                if (desc.isSuite()) {
                    return true;
                }
                String descString = desc.getDisplayName();
                TestFilter testFilter = this;
                synchronized (testFilter) {
                    Boolean shouldRun = this.testToRunStatus.get(descString);
                    if (shouldRun != null) {
                        return shouldRun;
                    }
                    shouldRun = this.testIdx % ConsoleRunner.this.numTestShards == ConsoleRunner.this.testShard;
                    ++this.testIdx;
                    this.testToRunStatus.put(descString, shouldRun);
                    return shouldRun;
                }
            }

            public String describe() {
                return "Filters a static subset of test methods";
            }
        }
        TestFilter testFilter = new TestFilter();
        class AlphabeticComparator
        implements Comparator<Description> {
            AlphabeticComparator() {
            }

            @Override
            public int compare(Description o1, Description o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        }
        AlphabeticComparator alphaComp = new AlphabeticComparator();
        ArrayList<Request> filteredRequests = new ArrayList<Request>(requests.size());
        for (Request request : requests) {
            filteredRequests.add(request.sortWith((Comparator)alphaComp).filterWith((Filter)testFilter));
        }
        for (Request request : filteredRequests) {
            request.getRunner().getDescription();
        }
        return filteredRequests;
    }

    private void notFoundError(String spec, PrintStream out, Throwable t) {
        out.printf("FATAL: Error during test discovery for %s: %s\n", spec, t);
        throw new RuntimeException("Classloading error during test discovery for " + spec, t);
    }

    public static void main(String[] args) {
        class Options {
            @Option(name="-fail-fast", usage="Causes the test suite run to fail fast.")
            private boolean failFast;
            @Option(name="-suppress-output", usage="Suppresses test output.")
            private boolean suppressOutput;
            @Option(name="-xmlreport", usage="Create ant compatible junit xml report files in -outdir.")
            private boolean xmlReport;
            @Option(name="-outdir", usage="Directory to output test captures too.  Only used if -suppress-output or -xmlreport is set.")
            private File outdir = new File(System.getProperty("java.io.tmpdir"));
            @Option(name="-per-test-timer", usage="Show progress and timer for each test class.")
            private boolean perTestTimer;
            @Option(name="-default-parallel", usage="Whether to run test classes without @TestParallel or @TestSerial in parallel.")
            private boolean defaultParallel;
            private int parallelThreads = 0;
            private int testShard;
            private int numTestShards;
            private int numRetries;
            @Argument(usage="Names of junit test classes or test methods to run.  Names prefixed with @ are considered arg file paths and these will be loaded and the whitespace delimited arguments found inside added to the list", required=true, metaVar="TESTS", handler=StringArrayOptionHandler.class)
            private String[] tests = new String[0];

            Options() {
            }

            @Option(name="-parallel-threads", usage="Number of threads to execute tests in parallel. Must be positive, or 0 to set automatically.")
            public void setParallelThreads(int parallelThreads) {
                if (parallelThreads < 0) {
                    throw new InvalidCmdLineArgumentException("-parallel-threads", (Object)parallelThreads, "-parallel-threads cannot be negative");
                }
                this.parallelThreads = parallelThreads;
                if (parallelThreads == 0) {
                    int availableProcessors;
                    this.parallelThreads = availableProcessors = Runtime.getRuntime().availableProcessors();
                    System.err.printf("Auto-detected %d processors, using -parallel-threads=%d\n", availableProcessors, this.parallelThreads);
                }
            }

            @Option(name="-test-shard", usage="Subset of tests to run, in the form M/N, 0 <= M < N. For example, 1/3 means run tests number 2, 5, 8, 11, ...")
            public void setTestShard(String shard) {
                String errorMsg = "-test-shard should be in the form M/N";
                int slashIdx = shard.indexOf(47);
                if (slashIdx < 0) {
                    throw new InvalidCmdLineArgumentException("-test-shard", (Object)shard, errorMsg);
                }
                try {
                    this.testShard = Integer.parseInt(shard.substring(0, slashIdx));
                    this.numTestShards = Integer.parseInt(shard.substring(slashIdx + 1));
                }
                catch (NumberFormatException ex) {
                    throw new InvalidCmdLineArgumentException("-test-shard", (Object)shard, errorMsg);
                }
                if (this.testShard < 0 || this.numTestShards <= 0 || this.testShard >= this.numTestShards) {
                    throw new InvalidCmdLineArgumentException("-test-shard", (Object)shard, "0 <= M < N is required in -test-shard M/N");
                }
            }

            @Option(name="-num-retries", usage="Number of attempts to retry each failing test, 0 by default")
            public void setNumRetries(int numRetries) {
                if (numRetries < 0) {
                    throw new InvalidCmdLineArgumentException("-num-retries", (Object)numRetries, "-num-retries cannot be negative");
                }
                this.numRetries = numRetries;
            }
        }
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            parser.printUsage((OutputStream)System.err);
            ConsoleRunner.exit(1);
        }
        catch (InvalidCmdLineArgumentException e) {
            parser.printUsage((OutputStream)System.err);
            ConsoleRunner.exit(1);
        }
        ConsoleRunner runner = new ConsoleRunner(options.failFast, options.suppressOutput, options.xmlReport, options.perTestTimer, options.outdir, options.defaultParallel, options.parallelThreads, options.testShard, options.numTestShards, options.numRetries);
        ArrayList tests = Lists.newArrayList();
        for (String test : options.tests) {
            if (test.startsWith("@")) {
                try {
                    String argFileContents = Files.toString((File)new File(test.substring(1)), (Charset)Charsets.UTF_8);
                    tests.addAll(Arrays.asList(argFileContents.split("\\s+")));
                }
                catch (IOException e) {
                    System.err.printf("Failed to load args from arg file %s: %s\n", test, e.getMessage());
                    ConsoleRunner.exit(1);
                }
                continue;
            }
            tests.add(test);
        }
        runner.run(tests);
    }

    private static boolean isTest(Class<?> clazz) {
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) {
            return false;
        }
        if (!Iterables.any(Arrays.asList(clazz.getConstructors()), IS_PUBLIC_CONSTRUCTOR)) {
            return false;
        }
        if (junit.framework.Test.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.isAnnotationPresent(RunWith.class)) {
            return true;
        }
        return Iterables.any(Arrays.asList(clazz.getMethods()), IS_ANNOTATED_TEST_METHOD);
    }

    private static void exit(int code) {
        exitStatus = code;
        if (callSystemExitOnFinish) {
            System.exit(code);
        } else if (code != 0) {
            throw new RuntimeException("ConsoleRunner exited with status " + code);
        }
    }

    static void setCallSystemExitOnFinish(boolean v) {
        callSystemExitOnFinish = v;
    }

    static int getExitStatus() {
        return exitStatus;
    }

    static void setExitStatus(int v) {
        exitStatus = v;
    }

    static {
        METHOD_PARSER = Pattern.compile("^([^#]+)#([^#]+)$");
        IS_PUBLIC_CONSTRUCTOR = new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> constructor) {
                return Modifier.isPublic(constructor.getModifiers());
            }
        };
        IS_ANNOTATED_TEST_METHOD = new Predicate<Method>(){

            public boolean apply(Method method) {
                return Modifier.isPublic(method.getModifiers()) && method.isAnnotationPresent(Test.class);
            }
        };
    }

    static class StreamCapturingListener
    extends ForwardingListener
    implements StreamSource {
        private final Map<Class<?>, StreamCapture> captures = Maps.newHashMap();
        private final File outdir;

        StreamCapturingListener(File outdir) {
            this.outdir = outdir;
        }

        @Override
        public void testRunStarted(Description description) throws Exception {
            this.registerTests(description.getChildren());
            super.testRunStarted(description);
        }

        private void registerTests(Iterable<Description> tests) throws IOException {
            for (Description test : tests) {
                this.registerTests(test.getChildren());
                if (!Util.isRunnable(test)) continue;
                StreamCapture capture = this.captures.get(test.getTestClass());
                if (capture == null) {
                    String prefix = test.getClassName();
                    File out = new File(this.outdir, prefix + ".out.txt");
                    Files.createParentDirs((File)out);
                    File err = new File(this.outdir, prefix + ".err.txt");
                    Files.createParentDirs((File)err);
                    capture = new StreamCapture(out, err);
                    this.captures.put(test.getTestClass(), capture);
                }
                capture.incrementUseCount();
            }
        }

        @Override
        public void testRunFinished(Result result) throws Exception {
            for (StreamCapture capture : this.captures.values()) {
                capture.dispose();
            }
            super.testRunFinished(result);
        }

        @Override
        public void testStarted(Description description) throws Exception {
            this.captures.get(description.getTestClass()).open();
            super.testStarted(description);
        }

        @Override
        public void testFinished(Description description) throws Exception {
            this.captures.get(description.getTestClass()).close();
            super.testFinished(description);
        }

        @Override
        public byte[] readOut(Class<?> testClass) throws IOException {
            return this.captures.get(testClass).readOut();
        }

        @Override
        public byte[] readErr(Class<?> testClass) throws IOException {
            return this.captures.get(testClass).readErr();
        }
    }

    static class StreamCapture {
        private final File out;
        private OutputStream outstream;
        private final File err;
        private OutputStream errstream;
        private int useCount;
        private boolean closed;

        StreamCapture(File out, File err) throws IOException {
            this.out = out;
            this.err = err;
        }

        void incrementUseCount() {
            ++this.useCount;
        }

        void open() throws FileNotFoundException {
            if (this.outstream == null) {
                this.outstream = new FileOutputStream(this.out);
            }
            if (this.errstream == null) {
                this.errstream = new FileOutputStream(this.err);
            }
            SWAPPABLE_OUT.swap(this.outstream);
            SWAPPABLE_ERR.swap(this.errstream);
        }

        void close() throws IOException {
            if (--this.useCount <= 0 && !this.closed) {
                if (this.outstream != null) {
                    Closeables.close((Closeable)this.outstream, (boolean)true);
                }
                if (this.errstream != null) {
                    Closeables.close((Closeable)this.errstream, (boolean)true);
                }
                this.closed = true;
            }
        }

        void dispose() throws IOException {
            this.useCount = 0;
            this.close();
        }

        byte[] readOut() throws IOException {
            return this.read(this.out);
        }

        byte[] readErr() throws IOException {
            return this.read(this.err);
        }

        private byte[] read(File file) throws IOException {
            Preconditions.checkState((boolean)this.closed, (Object)"Capture must be closed by all users before it can be read");
            return Files.toByteArray((File)file);
        }
    }

    static class SwappableStream<T extends OutputStream>
    extends FilterOutputStream {
        private final T original;

        SwappableStream(T out) {
            super((OutputStream)out);
            this.original = out;
        }

        OutputStream swap(OutputStream out) {
            OutputStream old = this.out;
            this.out = out;
            return old;
        }

        public T getOriginal() {
            return this.original;
        }
    }
}

