/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.pantsbuild.tools.junit.impl.StreamSource;
import org.pantsbuild.tools.junit.impl.Util;

class AntJunitXmlReportListener
extends RunListener {
    private final Map<Class<?>, TestSuite> suites = Maps.newHashMap();
    private final Map<Description, TestCase> cases = Maps.newHashMap();
    private final File outdir;
    private final StreamSource streamSource;

    AntJunitXmlReportListener(File outdir, StreamSource streamSource) {
        this.outdir = outdir;
        this.streamSource = streamSource;
    }

    public void testRunStarted(Description description) throws java.lang.Exception {
        this.createSuites(description.getChildren());
    }

    private void createSuites(Iterable<Description> tests) {
        for (Description test : tests) {
            this.createSuites(test.getChildren());
            if (!Util.isRunnable(test)) continue;
            Class testClass = test.getTestClass();
            TestSuite suite = this.suites.get(testClass);
            if (suite == null) {
                suite = new TestSuite(test);
                this.suites.put(testClass, suite);
            }
            TestCase testCase = new TestCase(test);
            suite.testCases.add(testCase);
            this.cases.put(test, testCase);
        }
    }

    public void testStarted(Description description) throws java.lang.Exception {
        this.suites.get(description.getTestClass()).started();
        this.cases.get(description).started();
    }

    public void testFailure(Failure failure) throws java.lang.Exception {
        Exception exception = new Exception(failure);
        Description description = failure.getDescription();
        boolean isFailure = Util.isAssertionFailure(failure);
        TestSuite suite = null;
        Class testClass = description.getTestClass();
        if (testClass != null) {
            suite = this.suites.get(testClass);
        }
        if (suite == null) {
            this.incrementUnknownSuiteFailure(description);
        } else if (isFailure) {
            suite.incrementFailures();
        } else {
            suite.incrementErrors();
        }
        TestCase testCase = this.cases.get(description);
        if (testCase == null) {
            this.incrementUnknownTestCaseFailure(description, exception);
        } else if (isFailure) {
            testCase.setFailure(exception);
        } else {
            testCase.setError(exception);
        }
    }

    public void testFinished(Description description) throws java.lang.Exception {
        this.cases.get(description).finished();
        this.suites.get(description.getTestClass()).finished();
    }

    public void testRunFinished(Result result) throws java.lang.Exception {
        for (Map.Entry<Class<?>, TestSuite> entry : this.suites.entrySet()) {
            Class<?> testClass = entry.getKey();
            TestSuite suite = entry.getValue();
            if (!suite.wasStarted()) continue;
            suite.setOut(new String(this.streamSource.readOut(testClass), Charsets.UTF_8));
            suite.setErr(new String(this.streamSource.readErr(testClass), Charsets.UTF_8));
            FileWriter xmlOut = new FileWriter(new File(this.outdir, String.format("TEST-%s.xml", suite.name)));
            JAXB.marshal((Object)suite, (Writer)new XmlWriter(xmlOut){

                @Override
                protected void handleInvalid(int c) throws IOException {
                    this.out.write(32);
                }
            });
        }
    }

    private void incrementUnknownSuiteFailure(Description description) {
        TestSuite unknownSuite;
        if (description == null || description.getTestClass() == null) {
            description = Description.createTestDescription(UnknownFailureSuite.class, (String)"unknown");
        }
        if ((unknownSuite = this.suites.get(description.getTestClass())) == null) {
            unknownSuite = new TestSuite(description);
            this.suites.put(description.getTestClass(), unknownSuite);
        }
        unknownSuite.incrementFailures();
    }

    private void incrementUnknownTestCaseFailure(Description description, Exception exception) {
        TestCase unknownCase = this.cases.get(description);
        if (unknownCase == null) {
            unknownCase = new TestCase(description);
            this.cases.put(description, unknownCase);
        }
        unknownCase.setFailure(exception);
    }

    private static String convertTimeSpanNs(long timespanNs) {
        return String.format("%f", (double)timespanNs / (double)TimeUnit.SECONDS.toNanos(1L));
    }

    @VisibleForTesting
    protected Map<Class<?>, TestSuite> getSuites() {
        return this.suites;
    }

    @VisibleForTesting
    protected Map<Description, TestCase> getCases() {
        return this.cases;
    }

    static class UnknownFailureSuite {
        UnknownFailureSuite() {
        }
    }

    private static abstract class XmlWriter
    extends FilterWriter {
        protected XmlWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                this.write(cbuf[i]);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                this.write(str.charAt(i));
            }
        }

        @Override
        public void write(int c) throws IOException {
            if (c == 9 || c == 10 || c == 13 || 32 <= c && c <= 55295 || 57344 <= c && c <= 65533 || 65536 <= c && c <= 0x10FFFF) {
                this.out.write(c);
            } else {
                this.handleInvalid(c);
            }
        }

        protected abstract void handleInvalid(int var1) throws IOException;
    }

    @XmlRootElement(name="testsuite")
    static class TestSuite {
        private final String name;
        private int errors;
        private int failures;
        private String hostname;
        private int tests;
        private String time;
        private String timestamp;
        private final List<Property> properties = ImmutableList.copyOf((Iterable)Iterables.transform(System.getProperties().entrySet(), (Function)new Function<Map.Entry<Object, Object>, Property>(){

            public Property apply(Map.Entry<Object, Object> entry) {
                return new Property(entry.getKey().toString(), entry.getValue().toString());
            }
        }));
        private final List<TestCase> testCases = Lists.newArrayList();
        private String out;
        private String err;
        private long startNs;

        TestSuite() {
            this.name = null;
        }

        TestSuite(Description test) {
            this.name = test.getClassName();
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.hostname = "localhost";
            }
        }

        @XmlAttribute
        public int getErrors() {
            return this.errors;
        }

        @XmlAttribute
        public int getFailures() {
            return this.failures;
        }

        @XmlAttribute
        public String getHostname() {
            return this.hostname;
        }

        @XmlAttribute
        public String getName() {
            return this.name;
        }

        @XmlAttribute
        public int getTests() {
            return this.tests;
        }

        @XmlAttribute
        public String getTime() {
            return this.time;
        }

        @XmlAttribute
        public String getTimestamp() {
            return this.timestamp;
        }

        @XmlElementRef
        @XmlElementWrapper(name="properties")
        public List<Property> getProperties() {
            return this.properties;
        }

        @XmlElementRef
        public List<TestCase> getTestCases() {
            return this.testCases;
        }

        @XmlElement(name="system-out")
        public String getOut() {
            return this.out;
        }

        public void setOut(String out) {
            this.out = out;
        }

        @XmlElement(name="system-err")
        public String getErr() {
            return this.err;
        }

        public void setErr(String err) {
            this.err = err;
        }

        public void started() {
            if (this.startNs == 0L) {
                this.timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
                this.startNs = System.nanoTime();
            }
        }

        public void finished() {
            if (++this.tests == this.testCases.size()) {
                this.time = AntJunitXmlReportListener.convertTimeSpanNs(System.nanoTime() - this.startNs);
            }
        }

        public void incrementFailures() {
            ++this.failures;
        }

        public void incrementErrors() {
            ++this.errors;
        }

        public boolean wasStarted() {
            return this.startNs > 0L;
        }
    }

    @XmlRootElement(name="property")
    static class Property {
        private final String name;
        private final String value;

        Property() {
            this.name = null;
            this.value = null;
        }

        Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @XmlAttribute
        public String getName() {
            return this.name;
        }

        @XmlAttribute
        public String getValue() {
            return this.value;
        }
    }

    @XmlRootElement(name="testcase")
    static class TestCase {
        private final String classname;
        private final String name;
        private String time;
        private Exception failure;
        private Exception error;
        private long startNs;

        TestCase() {
            this.classname = null;
            this.name = null;
        }

        TestCase(Description test) {
            this.classname = test.getClassName();
            this.name = test.getMethodName();
        }

        @XmlAttribute
        public String getClassname() {
            return this.classname;
        }

        @XmlAttribute
        public String getName() {
            return this.name;
        }

        @XmlAttribute
        public String getTime() {
            return this.time;
        }

        @XmlElement
        public Exception getFailure() {
            return this.failure;
        }

        public void setFailure(Exception failure) {
            this.failure = failure;
        }

        @XmlElement
        public Exception getError() {
            return this.error;
        }

        public void setError(Exception error) {
            this.error = error;
        }

        public void started() {
            this.startNs = System.nanoTime();
        }

        public void finished() {
            this.time = AntJunitXmlReportListener.convertTimeSpanNs(System.nanoTime() - this.startNs);
        }
    }

    @XmlRootElement
    static class Exception {
        private final String message;
        private final String type;
        private final String stacktrace;

        Exception() {
            this.message = null;
            this.type = null;
            this.stacktrace = null;
        }

        Exception(Failure failure) {
            this.message = failure.getMessage();
            this.type = failure.getException().getClass().getName();
            this.stacktrace = failure.getTrace();
        }

        @XmlAttribute
        public String getMessage() {
            return this.message;
        }

        @XmlAttribute
        public String getType() {
            return this.type;
        }

        @XmlValue
        public String getStacktrace() {
            return this.stacktrace;
        }
    }
}

