/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.util.List;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class CompositeRequest
extends ParentRunner<Request> {
    private final List<Request> requests;

    public CompositeRequest(List<Request> requests) throws InitializationError {
        super(null);
        this.requests = requests;
    }

    protected List<Request> getChildren() {
        return this.requests;
    }

    protected Description describeChild(Request child) {
        return child.getRunner().getDescription();
    }

    protected void runChild(Request child, RunNotifier notifier) {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, this.describeChild(child));
        try {
            ErrorReportingRunner erRunner;
            Description desc;
            Runner runner = child.getRunner();
            boolean exemptThisRunner = false;
            if (runner instanceof ErrorReportingRunner && "org.junit.runner.manipulation.Filter".equals((desc = (erRunner = (ErrorReportingRunner)runner).getDescription()).getDisplayName())) {
                exemptThisRunner = true;
            }
            if (!exemptThisRunner) {
                runner.run(notifier);
            }
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.fireTestIgnored();
        }
        catch (StoppedByUserException e) {
            throw e;
        }
        catch (Throwable e) {
            eachNotifier.addFailure(e);
        }
    }
}

