/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.util.List;
import org.junit.runner.Request;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.pantsbuild.tools.junit.impl.AnnotatedClassRequest;
import org.pantsbuild.tools.junit.impl.CompositeRequest;
import org.pantsbuild.tools.junit.impl.ConcurrentRunnerScheduler;

public class ConcurrentCompositeRequest
extends CompositeRequest {
    private final ConcurrentRunnerScheduler runnerScheduler;

    public ConcurrentCompositeRequest(List<Request> requests, boolean defaultParallel, int numThreads) throws InitializationError {
        super(requests);
        this.runnerScheduler = new ConcurrentRunnerScheduler(defaultParallel, numThreads);
        this.setScheduler(this.runnerScheduler);
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                for (final Request child : ConcurrentCompositeRequest.this.getChildren()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ConcurrentCompositeRequest.this.runChild(child, notifier);
                        }
                    };
                    if (child instanceof AnnotatedClassRequest) {
                        ConcurrentCompositeRequest.this.runnerScheduler.schedule(runnable, ((AnnotatedClassRequest)child).getClazz());
                        continue;
                    }
                    ConcurrentCompositeRequest.this.runnerScheduler.schedule(runnable);
                }
                ConcurrentCompositeRequest.this.runnerScheduler.finished();
            }
        };
    }
}

