/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.junit.runners.model.RunnerScheduler;
import org.pantsbuild.junit.annotations.TestParallel;
import org.pantsbuild.junit.annotations.TestSerial;

public class ConcurrentRunnerScheduler
implements RunnerScheduler {
    private final CompletionService<Void> completionService;
    private final Queue<Future<Void>> concurrentTasks;
    private final Queue<Runnable> serialTasks;
    private final boolean defaultParallel;

    public ConcurrentRunnerScheduler(boolean defaultParallel, int numThreads) {
        this.defaultParallel = defaultParallel;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("concurrent-junit-runner-%d").build();
        this.completionService = new ExecutorCompletionService<Void>(Executors.newFixedThreadPool(numThreads, threadFactory));
        this.concurrentTasks = new LinkedList<Future<Void>>();
        this.serialTasks = new LinkedList<Runnable>();
    }

    public void schedule(Runnable childStatement) {
        this.serialTasks.offer(childStatement);
    }

    public void schedule(Runnable childStatement, Class<?> clazz) {
        if (this.shouldRunParallel(clazz)) {
            this.concurrentTasks.offer(this.completionService.submit(childStatement, null));
        } else {
            this.serialTasks.offer(childStatement);
        }
    }

    private boolean shouldRunParallel(Class<?> clazz) {
        return !clazz.isAnnotationPresent(TestSerial.class) && (clazz.isAnnotationPresent(TestParallel.class) || this.defaultParallel);
    }

    public void finished() {
        try {
            while (!this.concurrentTasks.isEmpty()) {
                this.concurrentTasks.poll().get();
            }
            for (Runnable task : this.serialTasks) {
                task.run();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        finally {
            while (!this.concurrentTasks.isEmpty()) {
                this.concurrentTasks.poll().cancel(true);
            }
        }
    }
}

