/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.pantsbuild.tools.junit.impl.ListenerRegistry;

class ForwardingListener
extends RunListener
implements ListenerRegistry {
    private final List<RunListener> listeners = Lists.newArrayList();

    ForwardingListener() {
    }

    @Override
    public void addListener(RunListener listener) {
        this.listeners.add(listener);
    }

    private <E extends Exception> void fire(Event<E> dispatcher) throws E {
        for (RunListener listener : this.listeners) {
            dispatcher.fire(listener);
        }
    }

    public void testRunStarted(final Description description) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener listener) throws Exception {
                listener.testRunStarted(description);
            }
        });
    }

    public void testRunFinished(final Result result) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener listener) throws Exception {
                listener.testRunFinished(result);
            }
        });
    }

    public void testStarted(final Description description) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener listener) throws Exception {
                listener.testStarted(description);
            }
        });
    }

    public void testIgnored(final Description description) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener listener) throws Exception {
                listener.testIgnored(description);
            }
        });
    }

    public void testFailure(final Failure failure) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener listener) throws Exception {
                listener.testFailure(failure);
            }
        });
    }

    public void testFinished(final Description description) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener listener) throws Exception {
                listener.testFinished(description);
            }
        });
    }

    public void testAssumptionFailure(final Failure failure) {
        this.fire(new Event<RuntimeException>(){

            @Override
            public void fire(RunListener listener) {
                listener.testAssumptionFailure(failure);
            }
        });
    }

    private static interface Event<E extends Exception> {
        public void fire(RunListener var1) throws E;
    }
}

