/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.io.PrintStream;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.pantsbuild.tools.junit.impl.ConsoleListener;

class PerTestConsoleListener
extends ConsoleListener {
    private final PrintStream out;

    PerTestConsoleListener(PrintStream out) {
        super(out);
        this.out = out;
    }

    public void testRunStarted(Description description) throws Exception {
        String displayName = description.getDisplayName();
        if (displayName != "null") {
            this.out.println(displayName);
        }
    }

    public void testStarted(Description description) {
        this.out.print("\t" + description.getDisplayName());
    }

    public void testFinished(Description description) throws Exception {
        this.out.println();
    }

    @Override
    public void testFailure(Failure failure) {
        this.out.println(" -> FAILED");
    }
}

