/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.util.List;
import org.junit.runner.Request;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.pantsbuild.tools.junit.impl.AnnotatedClassRequest;
import org.pantsbuild.tools.junit.impl.CompositeRequest;
import org.pantsbuild.tools.junit.impl.ConcurrentRunnerScheduler;

public class ConcurrentCompositeRequest
extends CompositeRequest {
    private final ConcurrentRunnerScheduler runnerScheduler;

    public ConcurrentCompositeRequest(List<Request> list, boolean bl, int n) throws InitializationError {
        super(list);
        this.runnerScheduler = new ConcurrentRunnerScheduler(bl, n);
        this.setScheduler(this.runnerScheduler);
    }

    protected Statement childrenInvoker(final RunNotifier runNotifier) {
        return new Statement(){

            public void evaluate() {
                for (final Request request : ConcurrentCompositeRequest.this.getChildren()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ConcurrentCompositeRequest.this.runChild(request, runNotifier);
                        }
                    };
                    if (request instanceof AnnotatedClassRequest) {
                        ConcurrentCompositeRequest.this.runnerScheduler.schedule(runnable, ((AnnotatedClassRequest)request).getClazz());
                        continue;
                    }
                    ConcurrentCompositeRequest.this.runnerScheduler.schedule(runnable);
                }
                ConcurrentCompositeRequest.this.runnerScheduler.finished();
            }
        };
    }
}

