/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.Test;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.pantsbuild.args4j.InvalidCmdLineArgumentException;
import org.pantsbuild.tools.junit.impl.AbortableListener;
import org.pantsbuild.tools.junit.impl.AnnotatedClassRequest;
import org.pantsbuild.tools.junit.impl.AntJunitXmlReportListener;
import org.pantsbuild.tools.junit.impl.ConcurrentCompositeRequest;
import org.pantsbuild.tools.junit.impl.ConsoleListener;
import org.pantsbuild.tools.junit.impl.ForwardingListener;
import org.pantsbuild.tools.junit.impl.PerTestConsoleListener;
import org.pantsbuild.tools.junit.impl.StreamSource;
import org.pantsbuild.tools.junit.impl.Util;
import org.pantsbuild.tools.junit.withretry.AllDefaultPossibilitiesBuilderWithRetry;

public class ConsoleRunnerImpl {
    private static final SwappableStream<PrintStream> SWAPPABLE_OUT = new SwappableStream<PrintStream>(System.out);
    private static final SwappableStream<PrintStream> SWAPPABLE_ERR = new SwappableStream<PrintStream>(System.err);
    private static boolean callSystemExitOnFinish = true;
    private static int exitStatus;
    private static final Pattern METHOD_PARSER;
    private final boolean failFast;
    private final OutputMode outputMode;
    private final boolean xmlReport;
    private final File outdir;
    private final boolean perTestTimer;
    private final boolean defaultParallel;
    private final int parallelThreads;
    private final int testShard;
    private final int numTestShards;
    private final int numRetries;
    public static final Predicate<Constructor<?>> IS_PUBLIC_CONSTRUCTOR;
    private static final Predicate<Method> IS_ANNOTATED_TEST_METHOD;

    ConsoleRunnerImpl(boolean bl, OutputMode outputMode, boolean bl2, boolean bl3, File file, boolean bl4, int n, int n2, int n3, int n4) {
        this.failFast = bl;
        this.outputMode = outputMode;
        this.xmlReport = bl2;
        this.perTestTimer = bl3;
        this.outdir = file;
        this.defaultParallel = bl4;
        this.parallelThreads = n;
        this.testShard = n2;
        this.numTestShards = n3;
        this.numRetries = n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(Iterable<String> iterable) {
        Object object;
        System.setOut(new PrintStream(SWAPPABLE_OUT));
        System.setErr(new PrintStream(SWAPPABLE_ERR));
        List<Request> list = this.parseRequests(SWAPPABLE_OUT.getOriginal(), SWAPPABLE_ERR.getOriginal(), iterable);
        if (this.numTestShards > 0) {
            list = this.setFilterForTestShard(list);
        }
        JUnitCore jUnitCore = new JUnitCore();
        AbortableListener abortableListener = new AbortableListener(this.failFast){

            @Override
            protected void abort(Result result) {
                ConsoleRunnerImpl.exit(result.getFailureCount());
            }
        };
        jUnitCore.addListener((RunListener)abortableListener);
        if (this.xmlReport) {
            if (!this.outdir.exists() && !this.outdir.mkdirs()) {
                throw new IllegalStateException("Failed to create output directory: " + this.outdir);
            }
            object = new StreamCapturingListener(this.outdir, this.outputMode);
            abortableListener.addListener((RunListener)object);
            AntJunitXmlReportListener antJunitXmlReportListener = new AntJunitXmlReportListener(this.outdir, (StreamSource)object);
            abortableListener.addListener(antJunitXmlReportListener);
        }
        if (this.perTestTimer) {
            abortableListener.addListener((RunListener)new PerTestConsoleListener(SWAPPABLE_OUT.getOriginal()));
        } else {
            jUnitCore.addListener((RunListener)new ConsoleListener(SWAPPABLE_OUT.getOriginal()));
        }
        object = this.createAbnormalExitHook(abortableListener, SWAPPABLE_OUT.getOriginal());
        Runtime.getRuntime().addShutdownHook((Thread)object);
        int n = 0;
        try {
            if (this.parallelThreads > 1) {
                ConcurrentCompositeRequest concurrentCompositeRequest = new ConcurrentCompositeRequest(list, this.defaultParallel, this.parallelThreads);
                n = jUnitCore.run((Runner)concurrentCompositeRequest).getFailureCount();
            } else {
                for (Request request : list) {
                    Result result = jUnitCore.run(request);
                    n += result.getFailureCount();
                }
            }
        }
        catch (InitializationError initializationError) {
            n = 1;
        }
        finally {
            Runtime.getRuntime().removeShutdownHook((Thread)object);
        }
        ConsoleRunnerImpl.exit(n);
    }

    private Thread createAbnormalExitHook(final AbortableListener abortableListener, final PrintStream printStream) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    abortableListener.abort(new UnknownError("Abnormal VM exit - test crashed."));
                }
                catch (Exception exception) {
                    printStream.println(exception);
                    exception.printStackTrace(printStream);
                }
                printStream.println("FATAL: VM exiting uncleanly.");
                printStream.flush();
                Runtime.getRuntime().halt(1);
            }
        };
        return thread;
    }

    private List<Request> parseRequests(PrintStream printStream, PrintStream printStream2, Iterable<String> iterable) {
        class TestMethod {
            private final Class<?> clazz;
            private final String name;

            TestMethod(Class<?> clazz, String string) {
                this.clazz = clazz;
                this.name = string;
            }
        }
        Object object2;
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        LinkedHashSet linkedHashSet2 = Sets.newLinkedHashSet();
        for (String allDefaultPossibilitiesBuilderWithRetry : iterable) {
            object2 = METHOD_PARSER.matcher(allDefaultPossibilitiesBuilderWithRetry);
            try {
                Class<?> runtimeException;
                if (((Matcher)object2).matches()) {
                    runtimeException = this.loadClass(((Matcher)object2).group(1));
                    if (!ConsoleRunnerImpl.isTest(runtimeException)) continue;
                    String string = ((Matcher)object2).group(2);
                    linkedHashSet.add(new TestMethod(runtimeException, string));
                    continue;
                }
                runtimeException = this.loadClass(allDefaultPossibilitiesBuilderWithRetry);
                if (!ConsoleRunnerImpl.isTest(runtimeException)) continue;
                linkedHashSet2.add(runtimeException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.notFoundError(allDefaultPossibilitiesBuilderWithRetry, printStream, noClassDefFoundError);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.notFoundError(allDefaultPossibilitiesBuilderWithRetry, printStream, classNotFoundException);
            }
            catch (LinkageError linkageError) {
                this.notFoundError(allDefaultPossibilitiesBuilderWithRetry, printStream, linkageError);
            }
            catch (RuntimeException runtimeException) {
                this.notFoundError(allDefaultPossibilitiesBuilderWithRetry, printStream, runtimeException);
            }
        }
        ArrayList arrayList = Lists.newArrayList();
        if (!linkedHashSet2.isEmpty()) {
            if (this.perTestTimer || this.parallelThreads > 1) {
                for (Object object2 : linkedHashSet2) {
                    arrayList.add(new AnnotatedClassRequest((Class<?>)object2, this.numRetries, printStream2));
                }
            } else {
                try {
                    AllDefaultPossibilitiesBuilderWithRetry allDefaultPossibilitiesBuilderWithRetry = new AllDefaultPossibilitiesBuilderWithRetry(this.numRetries, printStream2);
                    object2 = new Computer().getSuite((RunnerBuilder)allDefaultPossibilitiesBuilderWithRetry, linkedHashSet2.toArray(new Class[linkedHashSet2.size()]));
                    arrayList.add(Request.runner((Runner)object2));
                }
                catch (InitializationError initializationError) {
                    throw new RuntimeException("Internal error: Suite constructor, called as above, should always complete");
                }
            }
        }
        for (Object object2 : linkedHashSet) {
            arrayList.add(new AnnotatedClassRequest(((TestMethod)object2).clazz, this.numRetries, printStream2).filterWith(Description.createTestDescription((Class)((TestMethod)object2).clazz, (String)((TestMethod)object2).name)));
        }
        return arrayList;
    }

    private Class<?> loadClass(String string) throws ClassNotFoundException {
        return Class.forName(string, false, this.getClass().getClassLoader());
    }

    private List<Request> setFilterForTestShard(List<Request> list) {
        class TestFilter
        extends Filter {
            private int testIdx;
            private HashMap<String, Boolean> testToRunStatus = new HashMap();

            TestFilter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean shouldRun(Description description) {
                if (description.isSuite()) {
                    return true;
                }
                String string = Util.getPantsFriendlyDisplayName(description);
                TestFilter testFilter = this;
                synchronized (testFilter) {
                    Boolean bl = this.testToRunStatus.get(string);
                    if (bl != null) {
                        return bl;
                    }
                    bl = this.testIdx % ConsoleRunnerImpl.this.numTestShards == ConsoleRunnerImpl.this.testShard;
                    ++this.testIdx;
                    this.testToRunStatus.put(string, bl);
                    return bl;
                }
            }

            public String describe() {
                return "Filters a static subset of test methods";
            }
        }
        TestFilter testFilter = new TestFilter();
        class AlphabeticComparator
        implements Comparator<Description> {
            AlphabeticComparator() {
            }

            @Override
            public int compare(Description description, Description description2) {
                return Util.getPantsFriendlyDisplayName(description).compareTo(Util.getPantsFriendlyDisplayName(description2));
            }
        }
        AlphabeticComparator alphabeticComparator = new AlphabeticComparator();
        ArrayList<Request> arrayList = new ArrayList<Request>(list.size());
        for (Request request : list) {
            arrayList.add(request.sortWith((Comparator)alphabeticComparator).filterWith((Filter)testFilter));
        }
        for (Request request : arrayList) {
            request.getRunner().getDescription();
        }
        return arrayList;
    }

    private void notFoundError(String string, PrintStream printStream, Throwable throwable) {
        printStream.printf("FATAL: Error during test discovery for %s: %s\n", string, throwable);
        throw new RuntimeException("Classloading error during test discovery for " + string, throwable);
    }

    public static void main(String[] stringArray) {
        class Options {
            @Option(name="-fail-fast", usage="Causes the test suite run to fail fast.")
            private boolean failFast;
            @Option(name="-output-mode", usage="Specify what part of output should be passed to stdout. In case of FAILURE_ONLY and parallel tests execution output can be partial or even wrong. (default: ALL)")
            private OutputMode outputMode = OutputMode.ALL;
            @Option(name="-xmlreport", usage="Create ant compatible junit xml report files in -outdir.")
            private boolean xmlReport;
            @Option(name="-outdir", usage="Directory to output test captures too.")
            private File outdir = new File(System.getProperty("java.io.tmpdir"));
            @Option(name="-per-test-timer", usage="Show a description of each test and timer for each test class.")
            private boolean perTestTimer;
            @Option(name="-default-parallel", usage="Whether to run test classes without @TestParallel or @TestSerial in parallel.")
            private boolean defaultParallel;
            private int parallelThreads = 0;
            private int testShard;
            private int numTestShards;
            private int numRetries;
            @Argument(usage="Names of junit test classes or test methods to run.  Names prefixed with @ are considered arg file paths and these will be loaded and the whitespace delimited arguments found inside added to the list", required=true, metaVar="TESTS", handler=StringArrayOptionHandler.class)
            private String[] tests = new String[0];

            Options() {
            }

            @Option(name="-parallel-threads", usage="Number of threads to execute tests in parallel. Must be positive, or 0 to set automatically.")
            public void setParallelThreads(int n) {
                if (n < 0) {
                    throw new InvalidCmdLineArgumentException("-parallel-threads", (Object)n, "-parallel-threads cannot be negative");
                }
                this.parallelThreads = n;
                if (n == 0) {
                    int n2;
                    this.parallelThreads = n2 = Runtime.getRuntime().availableProcessors();
                    System.err.printf("Auto-detected %d processors, using -parallel-threads=%d\n", n2, this.parallelThreads);
                }
            }

            @Option(name="-test-shard", usage="Subset of tests to run, in the form M/N, 0 <= M < N. For example, 1/3 means run tests number 2, 5, 8, 11, ...")
            public void setTestShard(String string) {
                String string2 = "-test-shard should be in the form M/N";
                int n = string.indexOf(47);
                if (n < 0) {
                    throw new InvalidCmdLineArgumentException("-test-shard", (Object)string, string2);
                }
                try {
                    this.testShard = Integer.parseInt(string.substring(0, n));
                    this.numTestShards = Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidCmdLineArgumentException("-test-shard", (Object)string, string2);
                }
                if (this.testShard < 0 || this.numTestShards <= 0 || this.testShard >= this.numTestShards) {
                    throw new InvalidCmdLineArgumentException("-test-shard", (Object)string, "0 <= M < N is required in -test-shard M/N");
                }
            }

            @Option(name="-num-retries", usage="Number of attempts to retry each failing test, 0 by default")
            public void setNumRetries(int n) {
                if (n < 0) {
                    throw new InvalidCmdLineArgumentException("-num-retries", (Object)n, "-num-retries cannot be negative");
                }
                this.numRetries = n;
            }
        }
        Options options = new Options();
        CmdLineParser cmdLineParser = new CmdLineParser((Object)options);
        try {
            cmdLineParser.parseArgument(stringArray);
        }
        catch (CmdLineException cmdLineException) {
            cmdLineParser.printUsage((OutputStream)System.err);
            ConsoleRunnerImpl.exit(1);
        }
        catch (InvalidCmdLineArgumentException invalidCmdLineArgumentException) {
            cmdLineParser.printUsage((OutputStream)System.err);
            ConsoleRunnerImpl.exit(1);
        }
        ConsoleRunnerImpl consoleRunnerImpl = new ConsoleRunnerImpl(options.failFast, options.outputMode, options.xmlReport, options.perTestTimer, options.outdir, options.defaultParallel, options.parallelThreads, options.testShard, options.numTestShards, options.numRetries);
        ArrayList arrayList = Lists.newArrayList();
        for (String string : options.tests) {
            if (string.startsWith("@")) {
                try {
                    String string2 = Files.toString((File)new File(string.substring(1)), (Charset)Charsets.UTF_8);
                    arrayList.addAll(Arrays.asList(string2.split("\\s+")));
                }
                catch (IOException iOException) {
                    System.err.printf("Failed to load args from arg file %s: %s\n", string, iOException.getMessage());
                    ConsoleRunnerImpl.exit(1);
                }
                continue;
            }
            arrayList.add(string);
        }
        consoleRunnerImpl.run(arrayList);
    }

    private static boolean isTest(Class<?> clazz) {
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) {
            return false;
        }
        if (!Iterables.any(Arrays.asList(clazz.getConstructors()), IS_PUBLIC_CONSTRUCTOR)) {
            return false;
        }
        if (junit.framework.Test.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.isAnnotationPresent(RunWith.class)) {
            return true;
        }
        return Iterables.any(Arrays.asList(clazz.getMethods()), IS_ANNOTATED_TEST_METHOD);
    }

    private static void exit(int n) {
        exitStatus = n;
        if (callSystemExitOnFinish) {
            System.exit(n);
        } else if (n != 0) {
            throw new RuntimeException("ConsoleRunner exited with status " + n);
        }
    }

    static void setCallSystemExitOnFinish(boolean bl) {
        callSystemExitOnFinish = bl;
    }

    static int getExitStatus() {
        return exitStatus;
    }

    static void setExitStatus(int n) {
        exitStatus = n;
    }

    static {
        METHOD_PARSER = Pattern.compile("^([^#]+)#([^#]+)$");
        IS_PUBLIC_CONSTRUCTOR = new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> constructor) {
                return Modifier.isPublic(constructor.getModifiers());
            }
        };
        IS_ANNOTATED_TEST_METHOD = new Predicate<Method>(){

            public boolean apply(Method method) {
                return Modifier.isPublic(method.getModifiers()) && method.isAnnotationPresent(Test.class);
            }
        };
    }

    static enum OutputMode {
        ALL,
        FAILURE_ONLY,
        NONE;

    }

    static class StreamCapturingListener
    extends ForwardingListener
    implements StreamSource {
        private final Map<Class<?>, StreamCapture> suiteCaptures = Maps.newHashMap();
        private final Map<Description, InMemoryStreamCapture> caseCaptures = Maps.newHashMap();
        private final File outdir;
        private final OutputMode outputMode;

        StreamCapturingListener(File file, OutputMode outputMode) {
            this.outdir = file;
            this.outputMode = outputMode;
        }

        @Override
        public void testRunStarted(Description description) throws Exception {
            this.registerTests(description.getChildren());
            super.testRunStarted(description);
        }

        private void registerTests(Iterable<Description> iterable) throws IOException {
            for (Description description : iterable) {
                this.registerTests(description.getChildren());
                if (!Util.isRunnable(description)) continue;
                StreamCapture streamCapture = this.suiteCaptures.get(description.getTestClass());
                if (streamCapture == null) {
                    String string = description.getClassName();
                    File file = new File(this.outdir, string + ".out.txt");
                    Files.createParentDirs((File)file);
                    File file2 = new File(this.outdir, string + ".err.txt");
                    Files.createParentDirs((File)file2);
                    streamCapture = new StreamCapture(file, file2);
                    this.suiteCaptures.put(description.getTestClass(), streamCapture);
                }
                streamCapture.incrementUseCount();
            }
        }

        @Override
        public void testRunFinished(Result result) throws Exception {
            for (StreamCapture streamCapture : this.suiteCaptures.values()) {
                streamCapture.dispose();
            }
            this.caseCaptures.clear();
            super.testRunFinished(result);
        }

        @Override
        public void testStarted(Description description) throws Exception {
            StreamCapture streamCapture = this.suiteCaptures.get(description.getTestClass());
            OutputStream outputStream = streamCapture.getOutputStream();
            OutputStream outputStream2 = streamCapture.getErrorStream();
            switch (this.outputMode) {
                case ALL: {
                    SWAPPABLE_OUT.swap((OutputStream)new TeeOutputStream(SWAPPABLE_OUT.getOriginal(), outputStream));
                    SWAPPABLE_ERR.swap((OutputStream)new TeeOutputStream(SWAPPABLE_ERR.getOriginal(), outputStream2));
                    break;
                }
                case FAILURE_ONLY: {
                    InMemoryStreamCapture inMemoryStreamCapture = new InMemoryStreamCapture();
                    this.caseCaptures.put(description, inMemoryStreamCapture);
                    SWAPPABLE_OUT.swap((OutputStream)new TeeOutputStream(inMemoryStreamCapture.getOutputStream(), outputStream));
                    SWAPPABLE_ERR.swap((OutputStream)new TeeOutputStream(inMemoryStreamCapture.getErrorStream(), outputStream2));
                    break;
                }
                case NONE: {
                    SWAPPABLE_OUT.swap(outputStream);
                    SWAPPABLE_ERR.swap(outputStream2);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            super.testStarted(description);
        }

        @Override
        public void testFailure(Failure failure) throws Exception {
            if (this.outputMode == OutputMode.FAILURE_ONLY) {
                InMemoryStreamCapture inMemoryStreamCapture = this.caseCaptures.remove(failure.getDescription());
                inMemoryStreamCapture.close();
                ((PrintStream)SWAPPABLE_OUT.getOriginal()).append(new String(inMemoryStreamCapture.readOut()));
                ((PrintStream)SWAPPABLE_ERR.getOriginal()).append(new String(inMemoryStreamCapture.readErr()));
            }
            super.testFailure(failure);
        }

        @Override
        public void testFinished(Description description) throws Exception {
            this.suiteCaptures.get(description.getTestClass()).close();
            if (this.caseCaptures.containsKey(description)) {
                this.caseCaptures.remove(description).close();
            }
            super.testFinished(description);
        }

        @Override
        public byte[] readOut(Class<?> clazz) throws IOException {
            return this.suiteCaptures.get(clazz).readOut();
        }

        @Override
        public byte[] readErr(Class<?> clazz) throws IOException {
            return this.suiteCaptures.get(clazz).readErr();
        }
    }

    static class InMemoryStreamCapture {
        private ByteArrayOutputStream outstream;
        private ByteArrayOutputStream errstream;
        private boolean closed;

        InMemoryStreamCapture() {
        }

        OutputStream getOutputStream() {
            if (this.outstream == null) {
                this.outstream = new ByteArrayOutputStream();
            }
            return this.outstream;
        }

        OutputStream getErrorStream() {
            if (this.errstream == null) {
                this.errstream = new ByteArrayOutputStream();
            }
            return this.errstream;
        }

        void close() throws IOException {
            if (!this.closed) {
                if (this.outstream != null) {
                    Closeables.close((Closeable)this.outstream, (boolean)true);
                }
                if (this.errstream != null) {
                    Closeables.close((Closeable)this.errstream, (boolean)true);
                }
                this.closed = true;
            }
        }

        byte[] readOut() throws IOException {
            return this.read(this.outstream);
        }

        byte[] readErr() throws IOException {
            return this.read(this.errstream);
        }

        private byte[] read(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            Preconditions.checkState((boolean)this.closed, (Object)"Capture must be closed by all users before it can be read");
            return byteArrayOutputStream.toByteArray();
        }
    }

    static class StreamCapture {
        private final File out;
        private OutputStream outstream;
        private final File err;
        private OutputStream errstream;
        private int useCount;
        private boolean closed;

        StreamCapture(File file, File file2) throws IOException {
            this.out = file;
            this.err = file2;
        }

        void incrementUseCount() {
            ++this.useCount;
        }

        OutputStream getOutputStream() throws FileNotFoundException {
            if (this.outstream == null) {
                this.outstream = new FileOutputStream(this.out);
            }
            return this.outstream;
        }

        OutputStream getErrorStream() throws FileNotFoundException {
            if (this.errstream == null) {
                this.errstream = new FileOutputStream(this.err);
            }
            return this.errstream;
        }

        void close() throws IOException {
            if (--this.useCount <= 0 && !this.closed) {
                if (this.outstream != null) {
                    Closeables.close((Closeable)this.outstream, (boolean)true);
                }
                if (this.errstream != null) {
                    Closeables.close((Closeable)this.errstream, (boolean)true);
                }
                this.closed = true;
            }
        }

        void dispose() throws IOException {
            this.useCount = 0;
            this.close();
        }

        byte[] readOut() throws IOException {
            return this.read(this.out);
        }

        byte[] readErr() throws IOException {
            return this.read(this.err);
        }

        private byte[] read(File file) throws IOException {
            Preconditions.checkState((boolean)this.closed, (Object)"Capture must be closed by all users before it can be read");
            return Files.toByteArray((File)file);
        }
    }

    static class SwappableStream<T extends OutputStream>
    extends FilterOutputStream {
        private final T original;

        SwappableStream(T t) {
            super((OutputStream)t);
            this.original = t;
        }

        OutputStream swap(OutputStream outputStream) {
            OutputStream outputStream2 = this.out;
            this.out = outputStream;
            return outputStream2;
        }

        public T getOriginal() {
            return this.original;
        }
    }
}

