/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.util.List;
import org.junit.runner.Request;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.pantsbuild.tools.junit.impl.AnnotatedClassRequest;
import org.pantsbuild.tools.junit.impl.CompositeRequestRunner;
import org.pantsbuild.tools.junit.impl.Concurrency;
import org.pantsbuild.tools.junit.impl.ConcurrentRunnerScheduler;

public class ConcurrentCompositeRequestRunner
extends CompositeRequestRunner {
    private final ConcurrentRunnerScheduler runnerScheduler;

    public ConcurrentCompositeRequestRunner(List<Request> list, Concurrency concurrency, int n) throws InitializationError {
        super(list);
        this.runnerScheduler = new ConcurrentRunnerScheduler(concurrency, n);
        this.setScheduler(this.runnerScheduler);
    }

    protected Statement childrenInvoker(final RunNotifier runNotifier) {
        return new Statement(){

            public void evaluate() {
                for (final Request request : ConcurrentCompositeRequestRunner.this.getChildren()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ConcurrentCompositeRequestRunner.this.runChild(request, runNotifier);
                        }
                    };
                    if (request instanceof AnnotatedClassRequest) {
                        ConcurrentCompositeRequestRunner.this.runnerScheduler.schedule(runnable, ((AnnotatedClassRequest)request).getClazz());
                        continue;
                    }
                    ConcurrentCompositeRequestRunner.this.runnerScheduler.schedule(runnable);
                }
                ConcurrentCompositeRequestRunner.this.runnerScheduler.finished();
            }
        };
    }
}

