/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.pantsbuild.tools.junit.impl.ListenerRegistry;

class ForwardingListener
extends RunListener
implements ListenerRegistry {
    private final List<RunListener> listeners = Lists.newArrayList();

    ForwardingListener() {
    }

    @Override
    public void addListener(RunListener runListener) {
        this.listeners.add(runListener);
    }

    private <E extends Exception> void fire(Event<E> event) throws E {
        for (RunListener runListener : this.listeners) {
            event.fire(runListener);
        }
    }

    public void testRunStarted(final Description description) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener runListener) throws Exception {
                runListener.testRunStarted(description);
            }
        });
    }

    public void testRunFinished(final Result result) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener runListener) throws Exception {
                runListener.testRunFinished(result);
            }
        });
    }

    public void testStarted(final Description description) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener runListener) throws Exception {
                runListener.testStarted(description);
            }
        });
    }

    public void testIgnored(final Description description) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener runListener) throws Exception {
                runListener.testIgnored(description);
            }
        });
    }

    public void testFailure(final Failure failure) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener runListener) throws Exception {
                runListener.testFailure(failure);
            }
        });
    }

    public void testFinished(final Description description) throws Exception {
        this.fire(new Event<Exception>(){

            @Override
            public void fire(RunListener runListener) throws Exception {
                runListener.testFinished(description);
            }
        });
    }

    public void testAssumptionFailure(final Failure failure) {
        this.fire(new Event<RuntimeException>(){

            @Override
            public void fire(RunListener runListener) {
                runListener.testAssumptionFailure(failure);
            }
        });
    }

    private static interface Event<E extends Exception> {
        public void fire(RunListener var1) throws E;
    }
}

