/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import junit.framework.Test;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.notification.Failure;

final class Util {
    static final Predicate<Method> IS_ANNOTATED_TEST_METHOD = new Predicate<Method>(){

        public boolean apply(Method method) {
            return Modifier.isPublic(method.getModifiers()) && method.isAnnotationPresent(org.junit.Test.class);
        }
    };
    static final Predicate<Constructor<?>> IS_PUBLIC_CONSTRUCTOR = new Predicate<Constructor<?>>(){

        public boolean apply(Constructor<?> constructor) {
            return Modifier.isPublic(constructor.getModifiers());
        }
    };

    private Util() {
    }

    static boolean isIgnored(Description description) {
        return description.getAnnotation(Ignore.class) != null;
    }

    static boolean isIgnored(Class<?> clazz) {
        return clazz.isAnnotationPresent(Ignore.class);
    }

    static boolean isRunnable(Description description) {
        return description.isTest() && !Util.isIgnored(description);
    }

    static boolean isRunnable(Class<?> clazz) {
        return Util.isTestClass(clazz) && !Util.isIgnored(clazz);
    }

    static boolean isAssertionFailure(Failure failure) {
        return failure.getException() instanceof AssertionError;
    }

    static String getPantsFriendlyDisplayName(Description description) {
        String string = description.getClassName();
        String string2 = description.getMethodName();
        String string3 = description.getDisplayName();
        if (string.equals(string3) || string2.equals(string3)) {
            return string3;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 1);
        stringBuffer.append(string);
        stringBuffer.append("#");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    static String sanitizeSuiteName(String string) {
        return string.replaceAll("[[\\p{Punct}][\\p{Space}]&&[^_.-]]", "-").replaceAll("[.]+$", "");
    }

    public static boolean isJunit3Test(Class<?> clazz) {
        return Test.class.isAssignableFrom(clazz);
    }

    public static boolean isUsingCustomRunner(Class<?> clazz) {
        return clazz.isAnnotationPresent(RunWith.class);
    }

    public static boolean isTestClass(Class<?> clazz) {
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) {
            return false;
        }
        if (!Iterables.any(Arrays.asList(clazz.getConstructors()), IS_PUBLIC_CONSTRUCTOR)) {
            return false;
        }
        if (Util.isJunit3Test(clazz)) {
            return true;
        }
        if (Util.isUsingCustomRunner(clazz)) {
            return true;
        }
        return Iterables.any(Arrays.asList(clazz.getMethods()), IS_ANNOTATED_TEST_METHOD);
    }
}

