/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.pantsbuild.tools.junit.impl.StreamSource;
import org.pantsbuild.tools.junit.impl.Util;

class AntJunitXmlReportListener
extends RunListener {
    private final Map<String, TestSuite> suites = Maps.newHashMap();
    private final Map<String, TestCase> cases = Maps.newHashMap();
    private final File outdir;
    private final StreamSource streamSource;

    AntJunitXmlReportListener(File file, StreamSource streamSource) {
        this.outdir = file;
        this.streamSource = streamSource;
    }

    public void testRunStarted(Description description) throws java.lang.Exception {
        this.createSuites(description.getChildren());
    }

    private TestSuite getTestSuiteFor(Description description) {
        return this.suites.get(description.getClassName());
    }

    private TestCase getTestCaseFor(Description description) {
        return this.cases.get(Util.getPantsFriendlyDisplayName(description));
    }

    private void createSuites(Iterable<Description> iterable) throws java.lang.Exception {
        for (Description description : iterable) {
            this.createSuites(description.getChildren());
            if (!description.isTest()) continue;
            String string = description.getClassName();
            TestSuite testSuite = this.suites.get(string);
            if (testSuite == null) {
                testSuite = new TestSuite(description);
                this.suites.put(string, testSuite);
            }
            TestCase testCase = new TestCase(description);
            testSuite.testCases.add(testCase);
            this.cases.put(Util.getPantsFriendlyDisplayName(description), testCase);
        }
    }

    public void testStarted(Description description) throws java.lang.Exception {
        if (!Util.isRunnable(description)) {
            return;
        }
        this.getTestSuiteFor(description).started();
        this.getTestCaseFor(description).started();
    }

    public void testAssumptionFailure(Failure failure) {
        TestCase testCase;
        Description description = failure.getDescription();
        if (!description.isTest()) {
            return;
        }
        TestSuite testSuite = this.getTestSuiteFor(description);
        if (testSuite != null) {
            testSuite.incrementSkipped();
        }
        if ((testCase = this.getTestCaseFor(description)) != null) {
            testCase.setSkipped(true);
        }
    }

    public void testFailure(Failure failure) throws java.lang.Exception {
        Description description = failure.getDescription();
        boolean bl = Util.isAssertionFailure(failure);
        TestSuite testSuite = this.getTestSuiteFor(description);
        if (testSuite == null) {
            this.incrementUnknownSuiteFailure(description);
        } else if (bl) {
            testSuite.incrementFailures();
        } else {
            testSuite.incrementErrors();
        }
        Exception exception = new Exception(failure);
        TestCase testCase = this.getTestCaseFor(description);
        if (testCase == null) {
            testCase = this.incrementUnknownTestCaseFailure(description, exception);
            if (description.isSuite()) {
                testCase.finished();
                testSuite.testCases.clear();
                testSuite.testCases.add(testCase);
                testSuite.finished();
            }
        } else if (bl) {
            testCase.setFailure(exception);
        } else {
            testCase.setError(exception);
        }
    }

    public void testIgnored(Description description) throws java.lang.Exception {
        TestCase testCase;
        if (!description.isTest()) {
            return;
        }
        TestSuite testSuite = this.getTestSuiteFor(description);
        if (testSuite != null) {
            testSuite.incrementSkipped();
            testSuite.finished();
        }
        if ((testCase = this.getTestCaseFor(description)) != null) {
            testCase.setSkipped(true);
        }
    }

    public void testFinished(Description description) throws java.lang.Exception {
        if (!Util.isRunnable(description)) {
            return;
        }
        TestCase testCase = this.getTestCaseFor(description);
        if (testCase == null) {
            throw new RuntimeException("No TestCase for '" + description.getClassName() + "#" + description.getMethodName() + "'");
        }
        testCase.finished();
        TestSuite testSuite = this.getTestSuiteFor(description);
        if (testSuite == null) {
            throw new RuntimeException("No suite for '" + description.getClassName() + "'.");
        }
        testSuite.finished();
    }

    public void testRunFinished(Result result) throws java.lang.Exception {
        for (TestSuite testSuite : this.suites.values()) {
            if (testSuite.wasStarted() && testSuite.testClass != null) {
                testSuite.setOut(new String(this.streamSource.readOut(testSuite.testClass), Charsets.UTF_8));
                testSuite.setErr(new String(this.streamSource.readErr(testSuite.testClass), Charsets.UTF_8));
            }
            if (testSuite.tests <= 0) continue;
            FileWriter fileWriter = new FileWriter(new File(this.outdir, String.format("TEST-%s.xml", testSuite.getName())));
            JAXB.marshal((Object)testSuite, (Writer)new XmlWriter(fileWriter){

                @Override
                protected void handleInvalid(int n) throws IOException {
                    this.out.write(32);
                }
            });
        }
    }

    private void incrementUnknownSuiteFailure(Description description) {
        TestSuite testSuite;
        if (description == null || description.getClassName() == null) {
            description = Description.createTestDescription(UnknownFailureSuite.class, (String)"unknown");
        }
        if ((testSuite = this.getTestSuiteFor(description)) == null) {
            testSuite = new TestSuite(description);
            this.suites.put(description.getClassName(), testSuite);
        }
        testSuite.incrementFailures();
    }

    private TestCase incrementUnknownTestCaseFailure(Description description, Exception exception) {
        TestCase testCase = this.getTestCaseFor(description);
        if (testCase == null) {
            testCase = new TestCase(description);
            this.cases.put(Util.getPantsFriendlyDisplayName(description), testCase);
        }
        testCase.setError(exception);
        return testCase;
    }

    private static String convertTimeSpanNs(long l) {
        return String.format("%f", (double)l / (double)TimeUnit.SECONDS.toNanos(1L));
    }

    @VisibleForTesting
    protected Map<String, TestSuite> getSuites() {
        return this.suites;
    }

    @VisibleForTesting
    protected Map<String, TestCase> getCases() {
        return this.cases;
    }

    static class UnknownFailureSuite {
        UnknownFailureSuite() {
        }
    }

    private static abstract class XmlWriter
    extends FilterWriter {
        protected XmlWriter(Writer writer) {
            super(writer);
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = n; i < n2; ++i) {
                this.write(cArray[i]);
            }
        }

        @Override
        public void write(String string, int n, int n2) throws IOException {
            for (int i = n; i < n2; ++i) {
                this.write(string.charAt(i));
            }
        }

        @Override
        public void write(int n) throws IOException {
            if (n == 9 || n == 10 || n == 13 || 32 <= n && n <= 55295 || 57344 <= n && n <= 65533 || 65536 <= n && n <= 0x10FFFF) {
                this.out.write(n);
            } else {
                this.handleInvalid(n);
            }
        }

        protected abstract void handleInvalid(int var1) throws IOException;
    }

    @XmlRootElement(name="testsuite")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class TestSuite {
        @XmlAttribute
        private final String name;
        @XmlTransient
        private final Class<?> testClass;
        @XmlAttribute
        private int errors;
        @XmlAttribute
        private int failures;
        @XmlAttribute
        private int skipped;
        @XmlAttribute
        private String hostname;
        @XmlAttribute
        private int tests;
        @XmlAttribute
        private String time;
        @XmlAttribute
        private String timestamp;
        @XmlElementRef
        @XmlElementWrapper(name="properties")
        private final List<Property> properties = Lists.newArrayList((Iterable)Iterables.transform(System.getProperties().entrySet(), (Function)new Function<Map.Entry<Object, Object>, Property>(this){
            final /* synthetic */ TestSuite this$0;
            {
                this.this$0 = testSuite;
            }

            public Property apply(Map.Entry<Object, Object> entry) {
                return new Property(entry.getKey().toString(), entry.getValue().toString());
            }
        }));
        @XmlElementRef
        private final List<TestCase> testCases = Lists.newArrayList();
        @XmlElement(name="system-out")
        private String out;
        @XmlElement(name="system-err")
        private String err;
        @XmlTransient
        private long startNs;

        private TestSuite() {
            this.name = null;
            this.testClass = null;
        }

        TestSuite(Description description) {
            this.name = description.getClassName();
            this.testClass = description.getTestClass();
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.hostname = "localhost";
            }
        }

        public int getErrors() {
            return this.errors;
        }

        public int getFailures() {
            return this.failures;
        }

        public int getSkipped() {
            return this.skipped;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getName() {
            return Util.sanitizeSuiteName(this.name);
        }

        public int getTests() {
            return this.tests;
        }

        public String getTime() {
            return this.time;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public List<TestCase> getTestCases() {
            return this.testCases;
        }

        public String getOut() {
            return this.out;
        }

        public void setOut(String string) {
            this.out = string;
        }

        public String getErr() {
            return this.err;
        }

        public void setErr(String string) {
            this.err = string;
        }

        public void started() {
            if (this.startNs == 0L) {
                this.timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
                this.startNs = System.nanoTime();
            }
        }

        public void finished() {
            ++this.tests;
            this.time = this.startNs != 0L ? AntJunitXmlReportListener.convertTimeSpanNs(System.nanoTime() - this.startNs) : "0";
        }

        public void incrementFailures() {
            ++this.failures;
        }

        public void incrementErrors() {
            ++this.errors;
        }

        public void incrementSkipped() {
            ++this.skipped;
        }

        public boolean wasStarted() {
            return this.startNs > 0L;
        }
    }

    @XmlRootElement(name="property")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class Property {
        @XmlAttribute
        private final String name;
        @XmlAttribute
        private final String value;

        private Property() {
            this.name = null;
            this.value = null;
        }

        Property(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    @XmlRootElement(name="testcase")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class TestCase {
        @XmlAttribute
        private final String classname;
        @XmlAttribute
        private final String name;
        @XmlAttribute
        private String time;
        @XmlElement
        private Exception failure;
        @XmlElement
        private Exception error;
        @XmlElement
        private String skipped;
        @XmlTransient
        private long startNs;

        private TestCase() {
            this.classname = null;
            this.name = null;
        }

        TestCase(Description description) {
            this.classname = description.getClassName();
            this.name = description.getMethodName() != null ? description.getMethodName() : description.getClassName();
        }

        public String getClassname() {
            return this.classname;
        }

        public String getName() {
            return this.name;
        }

        public String getTime() {
            return this.time;
        }

        public Exception getFailure() {
            return this.failure;
        }

        public void setFailure(Exception exception) {
            this.failure = exception;
        }

        public Exception getError() {
            return this.error;
        }

        public void setError(Exception exception) {
            this.error = exception;
        }

        public String getSkipped() {
            return this.skipped;
        }

        public void setSkipped(boolean bl) {
            if (bl) {
                this.skipped = "";
                this.time = "0";
            } else {
                this.skipped = null;
                this.time = null;
            }
        }

        public void started() {
            this.startNs = System.nanoTime();
        }

        public void finished() {
            this.time = this.startNs != 0L ? AntJunitXmlReportListener.convertTimeSpanNs(System.nanoTime() - this.startNs) : "0";
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class Exception {
        @XmlAttribute
        private final String message;
        @XmlAttribute
        private final String type;
        @XmlValue
        private final String stacktrace;

        private Exception() {
            this.message = null;
            this.type = null;
            this.stacktrace = null;
        }

        Exception(Failure failure) {
            this.message = failure.getMessage();
            this.type = failure.getException().getClass().getName();
            this.stacktrace = failure.getTrace();
        }

        public String getMessage() {
            return this.message;
        }

        public String getType() {
            return this.type;
        }

        public String getStacktrace() {
            return this.stacktrace;
        }
    }
}

