/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.pantsbuild.tools.junit.impl.Spec;
import org.pantsbuild.tools.junit.impl.SpecException;
import org.pantsbuild.tools.junit.impl.Util;

class SpecParser {
    private final Iterable<String> testSpecStrings;
    private final LinkedHashMap<Class<?>, Spec> specs = new LinkedHashMap();

    SpecParser(Iterable<String> iterable) {
        Preconditions.checkArgument((!Iterables.isEmpty(iterable) ? 1 : 0) != 0);
        this.testSpecStrings = iterable;
    }

    Collection<Spec> parse() throws SpecException {
        for (String string : this.testSpecStrings) {
            if (string.indexOf(35) >= 0) {
                this.addMethod(string);
                continue;
            }
            Optional<Spec> optional = this.getOrCreateSpec(string, string);
            optional.ifPresent(spec -> {
                if (this.specs.containsKey(spec.getSpecClass()) && !spec.getMethods().isEmpty()) {
                    throw new SpecException(string, "Request for entire class already requesting individual methods");
                }
            });
        }
        return this.specs.values();
    }

    private Optional<Spec> getOrCreateSpec(String string, String string2) throws SpecException {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            if (Util.isTestClass(clazz)) {
                return Optional.of(this.specs.computeIfAbsent(clazz, Spec::new));
            }
            return Optional.empty();
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            throw new SpecException(string2, String.format("Class %s not found in classpath.", string), throwable);
        }
        catch (LinkageError linkageError) {
            throw new SpecException(string2, String.format("Error linking %s.", string), linkageError);
        }
        catch (RuntimeException runtimeException) {
            throw new SpecException(string2, String.format("Error initializing %s.", string), runtimeException);
        }
    }

    private void addMethod(String string) throws SpecException {
        String[] stringArray = string.split("#");
        if (stringArray.length != 2) {
            throw new SpecException(string, "Expected only one # in spec");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Optional<Spec> optional = this.getOrCreateSpec(string2, string);
        optional.ifPresent(spec -> {
            for (Method method : spec.getSpecClass().getMethods()) {
                if (!method.getName().equals(string3)) continue;
                Spec spec2 = spec.withMethod(string3);
                this.specs.put(spec.getSpecClass(), spec2);
                return;
            }
            throw new SpecException(string, String.format("Method %s not found in class %s", string3, string2));
        });
    }
}

