/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.pantsbuild.tools.junit.impl.Util;

class TestMethod
implements Comparable<TestMethod> {
    final Class<?> clazz;
    final String name;

    TestMethod(Class<?> clazz, String string) {
        this.clazz = clazz;
        this.name = string;
    }

    static Collection<TestMethod> fromClass(Class<?> clazz) {
        ArrayList arrayList = Lists.newArrayList();
        for (Method method : Iterables.filter(Arrays.asList(clazz.getMethods()), Util.IS_ANNOTATED_TEST_METHOD)) {
            arrayList.add(new TestMethod(clazz, method.getName()));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public int compareTo(TestMethod testMethod) {
        int n = this.clazz.getName().compareTo(testMethod.clazz.getName());
        if (n == 0) {
            n = this.name.compareTo(testMethod.name);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TestMethod testMethod = (TestMethod)object;
        if (this.clazz != null ? !this.clazz.equals(testMethod.clazz) : testMethod.clazz != null) {
            return false;
        }
        return this.name != null ? this.name.equals(testMethod.name) : testMethod.name == null;
    }

    public int hashCode() {
        int n = this.clazz != null ? this.clazz.hashCode() : 0;
        n = 31 * n + (this.name != null ? this.name.hashCode() : 0);
        return n;
    }
}

