/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.pantsbuild.args4j.InvalidCmdLineArgumentException;
import org.pantsbuild.junit.annotations.TestParallel;
import org.pantsbuild.junit.annotations.TestSerial;
import org.pantsbuild.tools.junit.impl.AnnotatedClassRequest;
import org.pantsbuild.tools.junit.impl.AntJunitXmlReportListener;
import org.pantsbuild.tools.junit.impl.Concurrency;
import org.pantsbuild.tools.junit.impl.ConcurrentCompositeRequestRunner;
import org.pantsbuild.tools.junit.impl.ConsoleListener;
import org.pantsbuild.tools.junit.impl.CustomAnnotationBuilder;
import org.pantsbuild.tools.junit.impl.PerTestConsoleListener;
import org.pantsbuild.tools.junit.impl.ScalaTestUtil;
import org.pantsbuild.tools.junit.impl.ShutdownListener;
import org.pantsbuild.tools.junit.impl.Spec;
import org.pantsbuild.tools.junit.impl.SpecException;
import org.pantsbuild.tools.junit.impl.SpecParser;
import org.pantsbuild.tools.junit.impl.SpecSet;
import org.pantsbuild.tools.junit.impl.StreamSource;
import org.pantsbuild.tools.junit.impl.TestMethod;
import org.pantsbuild.tools.junit.impl.Util;
import org.pantsbuild.tools.junit.impl.experimental.ConcurrentComputer;

public class ConsoleRunnerImpl {
    private static boolean callSystemExitOnFinish = true;
    private static RunListener testListener = null;
    private final boolean failFast;
    private final OutputMode outputMode;
    private final boolean xmlReport;
    private final File outdir;
    private final boolean perTestTimer;
    private final Concurrency defaultConcurrency;
    private final int parallelThreads;
    private final int testShard;
    private final int numTestShards;
    private final int numRetries;
    private final boolean useExperimentalRunner;
    private final SwappableStream<PrintStream> swappableOut;
    private final SwappableStream<PrintStream> swappableErr;

    ConsoleRunnerImpl(boolean bl, OutputMode outputMode, boolean bl2, boolean bl3, File file, Concurrency concurrency, int n, int n2, int n3, int n4, boolean bl4, PrintStream printStream, PrintStream printStream2) {
        Preconditions.checkNotNull((Object)((Object)outputMode));
        Preconditions.checkNotNull((Object)((Object)concurrency));
        Preconditions.checkNotNull((Object)printStream);
        Preconditions.checkNotNull((Object)printStream2);
        this.failFast = bl;
        this.outputMode = outputMode;
        this.xmlReport = bl2;
        this.perTestTimer = bl3;
        this.outdir = file;
        this.defaultConcurrency = concurrency;
        this.parallelThreads = n;
        this.testShard = n2;
        this.numTestShards = n3;
        this.numRetries = n4;
        this.swappableOut = new SwappableStream<PrintStream>(printStream);
        this.swappableErr = new SwappableStream<PrintStream>(printStream2);
        this.useExperimentalRunner = bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(Collection<String> collection) {
        System.setOut(new PrintStream(this.swappableOut));
        System.setErr(new PrintStream(this.swappableErr));
        JUnitCore jUnitCore = new JUnitCore();
        if (testListener != null) {
            jUnitCore.addListener(testListener);
        }
        if (!this.outdir.exists() && !this.outdir.mkdirs()) {
            throw new IllegalStateException("Failed to create output directory: " + this.outdir);
        }
        StreamCapturingListener streamCapturingListener = new StreamCapturingListener(this.outdir, this.outputMode, this.swappableOut, this.swappableErr);
        jUnitCore.addListener((RunListener)streamCapturingListener);
        if (this.xmlReport) {
            jUnitCore.addListener((RunListener)new AntJunitXmlReportListener(this.outdir, streamCapturingListener));
        }
        if (this.perTestTimer) {
            jUnitCore.addListener((RunListener)new PerTestConsoleListener(this.swappableOut.getOriginal()));
        } else {
            jUnitCore.addListener((RunListener)new ConsoleListener(this.swappableOut.getOriginal()));
        }
        ShutdownListener shutdownListener = new ShutdownListener(this.swappableOut.getOriginal());
        jUnitCore.addListener((RunListener)shutdownListener);
        Thread thread = this.createUnexpectedExitHook(shutdownListener, this.swappableOut.getOriginal());
        Runtime.getRuntime().addShutdownHook(thread);
        int n = 1;
        try {
            Collection<Spec> collection2 = new SpecParser(collection).parse();
            n = this.useExperimentalRunner ? this.runExperimental(collection2, jUnitCore) : this.runLegacy(collection2, jUnitCore);
        }
        catch (SpecException specException) {
            this.swappableErr.getOriginal().println("Error parsing specs: " + specException.getMessage());
        }
        catch (InitializationError initializationError) {
            this.swappableErr.getOriginal().println("Error initializing JUnit: " + initializationError.getMessage());
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
        ConsoleRunnerImpl.exit(n == 0 ? 0 : 1);
    }

    private Thread createUnexpectedExitHook(final ShutdownListener shutdownListener, final PrintStream printStream) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    shutdownListener.unexpectedShutdown();
                }
                catch (Exception exception) {
                    printStream.println(exception);
                    exception.printStackTrace(printStream);
                }
                printStream.println("FATAL: VM exiting unexpectedly.");
                printStream.flush();
                Runtime.getRuntime().halt(1);
            }
        };
    }

    private int runExperimental(Collection<Spec> collection, JUnitCore jUnitCore) throws InitializationError {
        Preconditions.checkNotNull((Object)jUnitCore);
        int n = 0;
        SpecSet specSet = new SpecSet(collection, this.defaultConcurrency);
        if (this.numTestShards == 0) {
            n += this.runConcurrentTests(jUnitCore, specSet, Concurrency.PARALLEL_CLASSES_AND_METHODS);
            n += this.runConcurrentTests(jUnitCore, specSet, Concurrency.PARALLEL_CLASSES);
            n += this.runConcurrentTests(jUnitCore, specSet, Concurrency.PARALLEL_METHODS);
        }
        ImmutableList immutableList = ImmutableList.copyOf(specSet.specs());
        return n += this.runLegacy((Collection<Spec>)immutableList, jUnitCore);
    }

    private int runConcurrentTests(JUnitCore jUnitCore, SpecSet specSet, Concurrency concurrency) throws InitializationError {
        ConcurrentComputer concurrentComputer = new ConcurrentComputer(concurrency, this.parallelThreads);
        Class[] classArray = specSet.extract(concurrency).classes();
        CustomAnnotationBuilder customAnnotationBuilder = new CustomAnnotationBuilder(this.numRetries, this.swappableErr.getOriginal());
        Runner runner = concurrentComputer.getSuite((RunnerBuilder)customAnnotationBuilder, classArray);
        return jUnitCore.run(Request.runner((Runner)runner)).getFailureCount();
    }

    private int runLegacy(Collection<Spec> collection, JUnitCore jUnitCore) throws InitializationError {
        List<Request> list = this.legacyParseRequests(this.swappableErr.getOriginal(), collection);
        if (this.numTestShards > 0) {
            list = this.setFilterForTestShard(list);
        }
        if (this.parallelThreads > 1) {
            ConcurrentCompositeRequestRunner concurrentCompositeRequestRunner = new ConcurrentCompositeRequestRunner(list, this.defaultConcurrency, this.parallelThreads);
            if (this.failFast) {
                return jUnitCore.run((Runner)new FailFastRunner((Runner)concurrentCompositeRequestRunner)).getFailureCount();
            }
            return jUnitCore.run((Runner)concurrentCompositeRequestRunner).getFailureCount();
        }
        int n = 0;
        for (Request request : list) {
            Result result = this.failFast ? jUnitCore.run((Runner)new FailFastRunner(request.getRunner())) : jUnitCore.run(request);
            n += result.getFailureCount();
        }
        return n;
    }

    private List<Request> legacyParseRequests(PrintStream printStream, Collection<Spec> collection) {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        LinkedHashSet linkedHashSet2 = Sets.newLinkedHashSet();
        for (Spec object2 : collection) {
            if (object2.getMethods().isEmpty()) {
                linkedHashSet2.add(object2.getSpecClass());
                continue;
            }
            for (String string : object2.getMethods()) {
                linkedHashSet.add(new TestMethod(object2.getSpecClass(), string));
            }
        }
        ArrayList arrayList = Lists.newArrayList();
        if (!linkedHashSet2.isEmpty()) {
            if (this.perTestTimer || this.parallelThreads > 1) {
                for (Object object : linkedHashSet2) {
                    if (this.legacyShouldRunParallelMethods((Class<?>)object)) {
                        if (ScalaTestUtil.isScalaTestTest(object)) {
                            arrayList.add(new AnnotatedClassRequest((Class<?>)object, this.numRetries, printStream));
                            continue;
                        }
                        linkedHashSet.addAll(TestMethod.fromClass(object));
                        continue;
                    }
                    arrayList.add(new AnnotatedClassRequest((Class<?>)object, this.numRetries, printStream));
                }
            } else {
                try {
                    Object object;
                    CustomAnnotationBuilder customAnnotationBuilder = new CustomAnnotationBuilder(this.numRetries, printStream);
                    object = new Computer().getSuite((RunnerBuilder)customAnnotationBuilder, linkedHashSet2.toArray(new Class[linkedHashSet2.size()]));
                    arrayList.add(Request.runner((Runner)object));
                }
                catch (InitializationError initializationError) {
                    throw new RuntimeException("Internal error: Suite constructor, called as above, should always complete");
                }
            }
        }
        for (Object object : linkedHashSet) {
            arrayList.add(new AnnotatedClassRequest(((TestMethod)object).clazz, this.numRetries, printStream).filterWith(Description.createTestDescription(((TestMethod)object).clazz, (String)((TestMethod)object).name)));
        }
        return arrayList;
    }

    private boolean legacyShouldRunParallelMethods(Class<?> clazz) {
        if (!Util.isRunnable(clazz)) {
            return false;
        }
        if (Util.isJunit3Test(clazz) || Util.isUsingCustomRunner(clazz)) {
            return false;
        }
        if (clazz.isAnnotationPresent(TestSerial.class) || clazz.isAnnotationPresent(TestParallel.class)) {
            return false;
        }
        return this.defaultConcurrency.shouldRunMethodsParallel();
    }

    private List<Request> setFilterForTestShard(List<Request> list) {
        class TestFilter
        extends Filter {
            private int testIdx;
            private Map<String, Boolean> testToRunStatus = Maps.newHashMap();

            TestFilter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean shouldRun(Description description) {
                if (description.isSuite()) {
                    return true;
                }
                String string = Util.getPantsFriendlyDisplayName(description);
                TestFilter testFilter = this;
                synchronized (testFilter) {
                    Boolean bl = this.testToRunStatus.get(string);
                    if (bl != null) {
                        return bl;
                    }
                    bl = this.testIdx % ConsoleRunnerImpl.this.numTestShards == ConsoleRunnerImpl.this.testShard;
                    ++this.testIdx;
                    this.testToRunStatus.put(string, bl);
                    return bl;
                }
            }

            public String describe() {
                return "Filters a static subset of test methods";
            }
        }
        TestFilter testFilter = new TestFilter();
        class AlphabeticComparator
        implements Comparator<Description> {
            AlphabeticComparator() {
            }

            @Override
            public int compare(Description description, Description description2) {
                return Util.getPantsFriendlyDisplayName(description).compareTo(Util.getPantsFriendlyDisplayName(description2));
            }
        }
        AlphabeticComparator alphabeticComparator = new AlphabeticComparator();
        ArrayList<Request> arrayList = new ArrayList<Request>(list.size());
        for (Request request : list) {
            arrayList.add(request.sortWith((Comparator)alphabeticComparator).filterWith((Filter)testFilter));
        }
        for (Request request : arrayList) {
            request.getRunner().getDescription();
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        class Options {
            @Option(name="-fail-fast", usage="Causes the test suite run to fail fast.")
            private boolean failFast;
            @Option(name="-output-mode", usage="Specify what part of output should be passed to stdout. In case of FAILURE_ONLY and parallel tests execution output can be partial or even wrong. (default: ALL)")
            private OutputMode outputMode = OutputMode.ALL;
            @Option(name="-xmlreport", usage="Create ant compatible junit xml report files in -outdir.")
            private boolean xmlReport;
            @Option(name="-outdir", usage="Directory to output test captures too.")
            private File outdir = new File(System.getProperty("java.io.tmpdir"));
            @Option(name="-per-test-timer", usage="Show a description of each test and timer for each test class.")
            private boolean perTestTimer;
            @Option(name="-default-parallel", usage="DEPRECATED: use -default-concurrency instead.\nWhether to run test classes without @TestParallel or @TestSerial in parallel.")
            private boolean defaultParallel;
            @Option(name="-default-concurrency", usage="Specify how to parallelize running tests.\nUse -use-experimental-runner for PARALLEL_METHODS and PARALLEL_CLASSES_AND_METHODS")
            private Concurrency defaultConcurrency;
            private int parallelThreads = 0;
            private int testShard;
            private int numTestShards;
            private int numRetries;
            @Argument(usage="Names of junit test classes or test methods to run.  Names prefixed with @ are considered arg file paths and these will be loaded and the whitespace delimited arguments found inside added to the list", required=true, metaVar="TESTS", handler=StringArrayOptionHandler.class)
            private String[] tests = new String[0];
            @Option(name="-use-experimental-runner", usage="Use the experimental runner that has support for parallel methods")
            private boolean useExperimentalRunner = false;

            Options() {
            }

            @Option(name="-parallel-threads", usage="Number of threads to execute tests in parallel. Must be positive, or 0 to set automatically.")
            public void setParallelThreads(int n) {
                if (n < 0) {
                    throw new InvalidCmdLineArgumentException("-parallel-threads", (Object)n, "-parallel-threads cannot be negative");
                }
                this.parallelThreads = n;
                if (n == 0) {
                    int n2;
                    this.parallelThreads = n2 = Runtime.getRuntime().availableProcessors();
                    System.err.printf("Auto-detected %d processors, using -parallel-threads=%d\n", n2, this.parallelThreads);
                }
            }

            @Option(name="-test-shard", usage="Subset of tests to run, in the form M/N, 0 <= M < N. For example, 1/3 means run tests number 2, 5, 8, 11, ...")
            public void setTestShard(String string) {
                String string2 = "-test-shard should be in the form M/N";
                int n = string.indexOf(47);
                if (n < 0) {
                    throw new InvalidCmdLineArgumentException("-test-shard", (Object)string, string2);
                }
                try {
                    this.testShard = Integer.parseInt(string.substring(0, n));
                    this.numTestShards = Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidCmdLineArgumentException("-test-shard", (Object)string, string2);
                }
                if (this.testShard < 0 || this.numTestShards <= 0 || this.testShard >= this.numTestShards) {
                    throw new InvalidCmdLineArgumentException("-test-shard", (Object)string, "0 <= M < N is required in -test-shard M/N");
                }
            }

            @Option(name="-num-retries", usage="Number of attempts to retry each failing test, 0 by default")
            public void setNumRetries(int n) {
                if (n < 0) {
                    throw new InvalidCmdLineArgumentException("-num-retries", (Object)n, "-num-retries cannot be negative");
                }
                this.numRetries = n;
            }
        }
        Options options = new Options();
        CmdLineParser cmdLineParser = new CmdLineParser((Object)options);
        try {
            cmdLineParser.parseArgument(stringArray);
        }
        catch (CmdLineException cmdLineException) {
            cmdLineParser.printUsage((OutputStream)System.err);
            ConsoleRunnerImpl.exit(1);
        }
        catch (InvalidCmdLineArgumentException invalidCmdLineArgumentException) {
            cmdLineParser.printUsage((OutputStream)System.err);
            ConsoleRunnerImpl.exit(1);
        }
        options.defaultConcurrency = ConsoleRunnerImpl.computeConcurrencyOption(options.defaultConcurrency, options.defaultParallel);
        ConsoleRunnerImpl consoleRunnerImpl = new ConsoleRunnerImpl(options.failFast, options.outputMode, options.xmlReport, options.perTestTimer, options.outdir, options.defaultConcurrency, options.parallelThreads, options.testShard, options.numTestShards, options.numRetries, options.useExperimentalRunner, new PrintStream(new BufferedOutputStream(System.out), true), new PrintStream(new BufferedOutputStream(System.err), true));
        ArrayList arrayList = Lists.newArrayList();
        for (String string : options.tests) {
            if (string.startsWith("@")) {
                try {
                    String string2 = Files.toString((File)new File(string.substring(1)), (Charset)Charsets.UTF_8);
                    arrayList.addAll(Arrays.asList(string2.split("\\s+")));
                }
                catch (IOException iOException) {
                    System.err.printf("Failed to load args from arg file %s: %s\n", string, iOException.getMessage());
                    ConsoleRunnerImpl.exit(1);
                }
                continue;
            }
            arrayList.add(string);
        }
        consoleRunnerImpl.run(arrayList);
    }

    @VisibleForTesting
    static Concurrency computeConcurrencyOption(Concurrency concurrency, boolean bl) {
        if (concurrency != null) {
            return concurrency;
        }
        if (!bl) {
            return Concurrency.SERIAL;
        }
        return Concurrency.PARALLEL_CLASSES;
    }

    private static void exit(int n) {
        if (callSystemExitOnFinish) {
            System.exit(n);
        } else if (n != 0) {
            throw new RuntimeException("ConsoleRunner exited with status " + n);
        }
    }

    public static void setCallSystemExitOnFinish(boolean bl) {
        callSystemExitOnFinish = bl;
    }

    public static void addTestListener(RunListener runListener) {
        testListener = runListener;
    }

    static enum OutputMode {
        ALL,
        FAILURE_ONLY,
        NONE;

    }

    public static class FailFastRunner
    extends Runner {
        private final Runner wrappedRunner;

        public FailFastRunner(Runner runner) {
            this.wrappedRunner = runner;
        }

        public Description getDescription() {
            return this.wrappedRunner.getDescription();
        }

        public void run(RunNotifier runNotifier) {
            runNotifier.addListener((RunListener)new FailFastListener(runNotifier));
            this.wrappedRunner.run(runNotifier);
        }
    }

    public static class FailFastListener
    extends RunListener {
        private final RunNotifier runNotifier;
        private final Result result = new Result();

        public FailFastListener(RunNotifier runNotifier) {
            this.runNotifier = runNotifier;
            this.runNotifier.addListener(this.result.createListener());
        }

        public void testFailure(Failure failure) throws Exception {
            this.runNotifier.fireTestFinished(failure.getDescription());
            this.runNotifier.fireTestRunFinished(this.result);
            this.runNotifier.pleaseStop();
        }
    }

    static class StreamCapturingListener
    extends RunListener
    implements StreamSource {
        private final Map<Class<?>, StreamCapture> suiteCaptures = Maps.newHashMap();
        private final Map<Description, InMemoryStreamCapture> caseCaptures = Maps.newHashMap();
        private final File outdir;
        private final OutputMode outputMode;
        private final SwappableStream<PrintStream> swappableOut;
        private final SwappableStream<PrintStream> swappableErr;

        StreamCapturingListener(File file, OutputMode outputMode, SwappableStream<PrintStream> swappableStream, SwappableStream<PrintStream> swappableStream2) {
            this.outdir = file;
            this.outputMode = outputMode;
            this.swappableOut = swappableStream;
            this.swappableErr = swappableStream2;
        }

        public void testRunStarted(Description description) throws Exception {
            this.registerTests(description.getChildren());
            super.testRunStarted(description);
        }

        private void registerTests(Iterable<Description> iterable) throws IOException {
            for (Description description : iterable) {
                this.registerTests(description.getChildren());
                if (!Util.isRunnable(description)) continue;
                StreamCapture streamCapture = this.suiteCaptures.get(description.getTestClass());
                if (streamCapture == null) {
                    String string = description.getClassName();
                    File file = new File(this.outdir, string + ".out.txt");
                    Files.createParentDirs((File)file);
                    File file2 = new File(this.outdir, string + ".err.txt");
                    Files.createParentDirs((File)file2);
                    streamCapture = new StreamCapture(file, file2);
                    this.suiteCaptures.put(description.getTestClass(), streamCapture);
                }
                streamCapture.incrementUseCount();
            }
        }

        public void testRunFinished(Result result) throws Exception {
            for (StreamCapture streamCapture : this.suiteCaptures.values()) {
                streamCapture.dispose();
            }
            this.caseCaptures.clear();
            super.testRunFinished(result);
        }

        public void testStarted(Description description) throws Exception {
            StreamCapture streamCapture = this.suiteCaptures.get(description.getTestClass());
            OutputStream outputStream = streamCapture.getOutputStream();
            OutputStream outputStream2 = streamCapture.getErrorStream();
            switch (this.outputMode) {
                case ALL: {
                    this.swappableOut.swap((OutputStream)new TeeOutputStream((OutputStream)this.swappableOut.getOriginal(), outputStream));
                    this.swappableErr.swap((OutputStream)new TeeOutputStream((OutputStream)this.swappableErr.getOriginal(), outputStream2));
                    break;
                }
                case FAILURE_ONLY: {
                    InMemoryStreamCapture inMemoryStreamCapture = new InMemoryStreamCapture();
                    this.caseCaptures.put(description, inMemoryStreamCapture);
                    this.swappableOut.swap((OutputStream)new TeeOutputStream(inMemoryStreamCapture.getOutputStream(), outputStream));
                    this.swappableErr.swap((OutputStream)new TeeOutputStream(inMemoryStreamCapture.getErrorStream(), outputStream2));
                    break;
                }
                case NONE: {
                    this.swappableOut.swap(outputStream);
                    this.swappableErr.swap(outputStream2);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            super.testStarted(description);
        }

        public void testFailure(Failure failure) throws Exception {
            if (this.outputMode == OutputMode.FAILURE_ONLY && this.caseCaptures.containsKey(failure.getDescription())) {
                InMemoryStreamCapture inMemoryStreamCapture = this.caseCaptures.remove(failure.getDescription());
                inMemoryStreamCapture.close();
                this.swappableOut.getOriginal().append(new String(inMemoryStreamCapture.readOut(), StandardCharsets.UTF_8));
                this.swappableErr.getOriginal().append(new String(inMemoryStreamCapture.readErr(), StandardCharsets.UTF_8));
            }
            super.testFailure(failure);
        }

        public void testFinished(Description description) throws Exception {
            this.suiteCaptures.get(description.getTestClass()).close();
            if (this.caseCaptures.containsKey(description)) {
                this.caseCaptures.remove(description).close();
            }
            super.testFinished(description);
        }

        @Override
        public byte[] readOut(Class<?> clazz) throws IOException {
            return this.suiteCaptures.get(clazz).readOut();
        }

        @Override
        public byte[] readErr(Class<?> clazz) throws IOException {
            return this.suiteCaptures.get(clazz).readErr();
        }
    }

    static class InMemoryStreamCapture {
        private ByteArrayOutputStream outstream;
        private ByteArrayOutputStream errstream;
        private boolean closed;

        InMemoryStreamCapture() {
        }

        OutputStream getOutputStream() {
            if (this.outstream == null) {
                this.outstream = new ByteArrayOutputStream();
            }
            return this.outstream;
        }

        OutputStream getErrorStream() {
            if (this.errstream == null) {
                this.errstream = new ByteArrayOutputStream();
            }
            return this.errstream;
        }

        void close() throws IOException {
            if (!this.closed) {
                if (this.outstream != null) {
                    Closeables.close((Closeable)this.outstream, (boolean)true);
                }
                if (this.errstream != null) {
                    Closeables.close((Closeable)this.errstream, (boolean)true);
                }
                this.closed = true;
            }
        }

        byte[] readOut() throws IOException {
            return this.read(this.outstream);
        }

        byte[] readErr() throws IOException {
            return this.read(this.errstream);
        }

        private byte[] read(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            Preconditions.checkState((boolean)this.closed, (Object)"Capture must be closed by all users before it can be read");
            return byteArrayOutputStream.toByteArray();
        }
    }

    static class StreamCapture {
        private final File out;
        private OutputStream outstream;
        private final File err;
        private OutputStream errstream;
        private int useCount;
        private boolean closed;

        StreamCapture(File file, File file2) throws IOException {
            this.out = file;
            this.err = file2;
        }

        void incrementUseCount() {
            ++this.useCount;
        }

        OutputStream getOutputStream() throws FileNotFoundException {
            if (this.outstream == null) {
                this.outstream = new FileOutputStream(this.out);
            }
            return this.outstream;
        }

        OutputStream getErrorStream() throws FileNotFoundException {
            if (this.errstream == null) {
                this.errstream = new FileOutputStream(this.err);
            }
            return this.errstream;
        }

        void close() throws IOException {
            if (--this.useCount <= 0 && !this.closed) {
                if (this.outstream != null) {
                    Closeables.close((Closeable)this.outstream, (boolean)true);
                }
                if (this.errstream != null) {
                    Closeables.close((Closeable)this.errstream, (boolean)true);
                }
                this.closed = true;
            }
        }

        void dispose() throws IOException {
            this.useCount = 0;
            this.close();
        }

        byte[] readOut() throws IOException {
            return this.read(this.out);
        }

        byte[] readErr() throws IOException {
            return this.read(this.err);
        }

        private byte[] read(File file) throws IOException {
            Preconditions.checkState((boolean)this.closed, (Object)"Capture must be closed by all users before it can be read");
            return Files.toByteArray((File)file);
        }
    }

    static class SwappableStream<T extends OutputStream>
    extends FilterOutputStream {
        private final T original;

        SwappableStream(T t) {
            super((OutputStream)t);
            this.original = t;
        }

        OutputStream swap(OutputStream outputStream) {
            OutputStream outputStream2 = this.out;
            this.out = outputStream;
            return outputStream2;
        }

        public T getOriginal() {
            return this.original;
        }
    }
}

