/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.pantsbuild.tools.junit.impl.Concurrency;
import org.pantsbuild.tools.junit.impl.Spec;

class SpecSet {
    private final Set<Spec> specs;
    private final Concurrency defaultConcurrency;

    public SpecSet(Collection<Spec> collection, Concurrency concurrency) {
        this.specs = new LinkedHashSet<Spec>(collection);
        this.defaultConcurrency = concurrency;
    }

    public SpecSet extract(Concurrency concurrency) {
        LinkedHashSet<Spec> linkedHashSet = new LinkedHashSet<Spec>();
        for (Spec spec : this.specs) {
            if (!spec.getMethods().isEmpty() || !spec.getConcurrency(this.defaultConcurrency).equals((Object)concurrency)) continue;
            linkedHashSet.add(spec);
        }
        this.specs.removeAll(linkedHashSet);
        return new SpecSet(linkedHashSet, this.defaultConcurrency);
    }

    public Set<Spec> specs() {
        return ImmutableSet.copyOf(this.specs);
    }

    public Class<?>[] classes() {
        Class[] classArray = new Class[this.specs.size()];
        int n = 0;
        for (Spec spec : this.specs) {
            classArray[n++] = spec.getSpecClass();
        }
        return classArray;
    }
}

