/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.io.PrintStream;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.pantsbuild.tools.junit.impl.ConsoleListener;

public class ShutdownListener
extends ConsoleListener {
    private final Result result = new Result();
    private final RunListener resultListener = this.result.createListener();
    private Description currentTestDescription;

    public ShutdownListener(PrintStream printStream) {
        super(printStream);
    }

    public void unexpectedShutdown() {
        if (this.currentTestDescription != null) {
            Failure failure = new Failure(this.currentTestDescription, (Throwable)new UnknownError("Abnormal VM exit - test crashed."));
            this.testFailure(failure);
        }
        super.testRunFinished(this.result);
    }

    public void testRunStarted(Description description) throws Exception {
        this.currentTestDescription = description;
        this.resultListener.testRunStarted(description);
    }

    @Override
    public void testRunFinished(Result result) {
        try {
            this.resultListener.testRunFinished(result);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void testFinished(Description description) throws Exception {
        this.resultListener.testFinished(description);
    }

    @Override
    public void testFailure(Failure failure) {
        try {
            this.resultListener.testFailure(failure);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void testIgnored(Description description) {
        try {
            this.resultListener.testIgnored(description);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

