/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.io.PrintStream;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;
import org.pantsbuild.tools.junit.impl.ScalaTestUtil;
import org.pantsbuild.tools.junit.withretry.JUnit4BuilderWithRetry;

public class CustomAnnotationBuilder
extends AllDefaultPossibilitiesBuilder {
    private final int numRetries;
    private final PrintStream err;

    public CustomAnnotationBuilder(int n, PrintStream printStream) {
        super(true);
        this.numRetries = n;
        this.err = printStream;
    }

    public JUnit4Builder junit4Builder() {
        return new JUnit4BuilderWithRetry(this.numRetries, this.err);
    }

    protected AnnotatedBuilder annotatedBuilder() {
        return new ScalaTestAnnotatedBuilder((RunnerBuilder)this);
    }

    private static class ScalaTestAnnotatedBuilder
    extends AnnotatedBuilder {
        ScalaTestAnnotatedBuilder(RunnerBuilder runnerBuilder) {
            super(runnerBuilder);
        }

        public Runner runnerForClass(Class<?> clazz) throws Exception {
            Runner runner = super.runnerForClass(clazz);
            if (runner == null && ScalaTestUtil.isScalaTestTest(clazz)) {
                return ScalaTestUtil.getJUnitRunner(clazz);
            }
            return runner;
        }
    }
}

