/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.util.List;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class CompositeRequestRunner
extends ParentRunner<Request> {
    private final List<Request> requests;

    public CompositeRequestRunner(List<Request> list) throws InitializationError {
        super(null);
        this.requests = list;
    }

    protected List<Request> getChildren() {
        return this.requests;
    }

    protected Description describeChild(Request request) {
        return request.getRunner().getDescription();
    }

    protected void runChild(Request request, RunNotifier runNotifier) {
        EachTestNotifier eachTestNotifier = new EachTestNotifier(runNotifier, this.describeChild(request));
        try {
            ErrorReportingRunner errorReportingRunner;
            Description description;
            Runner runner = request.getRunner();
            boolean bl = false;
            if (runner instanceof ErrorReportingRunner && "org.junit.runner.manipulation.Filter".equals((description = (errorReportingRunner = (ErrorReportingRunner)runner).getDescription()).getDisplayName())) {
                bl = true;
            }
            if (!bl) {
                runner.run(runNotifier);
            }
        }
        catch (AssumptionViolatedException assumptionViolatedException) {
            eachTestNotifier.fireTestIgnored();
        }
        catch (StoppedByUserException stoppedByUserException) {
            throw stoppedByUserException;
        }
        catch (Throwable throwable) {
            eachTestNotifier.addFailure(throwable);
        }
    }
}

