/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import org.pantsbuild.junit.annotations.TestParallel;
import org.pantsbuild.junit.annotations.TestParallelClassesAndMethods;
import org.pantsbuild.junit.annotations.TestParallelMethods;
import org.pantsbuild.junit.annotations.TestSerial;
import org.pantsbuild.tools.junit.impl.Concurrency;

class Spec {
    private final Class<?> clazz;
    private final ImmutableSet<String> methods;
    private static final ImmutableSet<String> empty = ImmutableSet.of();

    Spec(Class<?> clazz) {
        this(clazz, empty);
    }

    private Spec(Class<?> clazz, ImmutableSet<String> immutableSet) {
        this.clazz = Objects.requireNonNull(clazz);
        this.methods = Objects.requireNonNull(immutableSet);
    }

    String getSpecName() {
        return this.clazz.getName();
    }

    Class<?> getSpecClass() {
        return this.clazz;
    }

    Spec withMethod(String string) {
        return new Spec(this.clazz, (ImmutableSet<String>)ImmutableSet.builder().addAll(this.methods).add((Object)string).build());
    }

    Concurrency getConcurrency(Concurrency concurrency) {
        if (this.clazz.isAnnotationPresent(TestSerial.class)) {
            return Concurrency.SERIAL;
        }
        if (this.clazz.isAnnotationPresent(TestParallel.class)) {
            return Concurrency.PARALLEL_CLASSES;
        }
        if (this.clazz.isAnnotationPresent(TestParallelMethods.class)) {
            return Concurrency.PARALLEL_METHODS;
        }
        if (this.clazz.isAnnotationPresent(TestParallelClassesAndMethods.class)) {
            return Concurrency.PARALLEL_CLASSES_AND_METHODS;
        }
        return concurrency;
    }

    public Collection<String> getMethods() {
        return this.methods;
    }
}

