/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.pantsbuild.tools.junit.impl.Spec;
import org.pantsbuild.tools.junit.impl.SpecException;
import org.pantsbuild.tools.junit.impl.Util;

class SpecParser {
    private final Iterable<String> testSpecStrings;
    private final LinkedHashMap<Class<?>, Spec> specs = new LinkedHashMap();

    SpecParser(Iterable<String> iterable) {
        Preconditions.checkArgument((!Iterables.isEmpty(iterable) ? 1 : 0) != 0);
        this.testSpecStrings = iterable;
    }

    Collection<Spec> parse() throws SpecException {
        for (String string : this.testSpecStrings) {
            Spec spec;
            if (string.indexOf(35) >= 0) {
                this.addMethod(string);
                continue;
            }
            Optional<Spec> optional = this.getOrCreateSpec(string, string);
            if (!optional.isPresent() || !this.specs.containsKey((spec = (Spec)optional.get()).getSpecClass()) || spec.getMethods().isEmpty()) continue;
            throw new SpecException(string, "Request for entire class already requesting individual methods");
        }
        return this.specs.values();
    }

    private Optional<Spec> getOrCreateSpec(String string, String string2) throws SpecException {
        Class<?> clazz = this.loadClassOrThrow(string, string2);
        if (Util.isTestClass(clazz)) {
            if (!this.specs.containsKey(clazz)) {
                Spec spec = new Spec(clazz);
                this.specs.put(clazz, spec);
            }
            return Optional.of((Object)this.specs.get(clazz));
        }
        return Optional.absent();
    }

    private Class<?> loadClassOrThrow(String string, String string2) {
        try {
            return this.getClass().getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            throw new SpecException(string2, String.format("Class %s not found in classpath.", string), throwable);
        }
        catch (LinkageError linkageError) {
            throw new SpecException(string2, String.format("Error linking %s.", string), linkageError);
        }
        catch (Exception exception) {
            throw new SpecException(string2, String.format("Error initializing %s.", string), exception);
        }
    }

    private void addMethod(String string) throws SpecException {
        String[] stringArray = string.split("#");
        if (stringArray.length != 2) {
            throw new SpecException(string, "Expected only one # in spec");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Optional<Spec> optional = this.getOrCreateSpec(string2, string);
        if (optional.isPresent()) {
            Spec spec = (Spec)optional.get();
            for (Method method : spec.getSpecClass().getMethods()) {
                if (!method.getName().equals(string3)) continue;
                Spec spec2 = spec.withMethod(string3);
                this.specs.put(spec.getSpecClass(), spec2);
                return;
            }
            throw new SpecException(string, String.format("Method %s not found in class %s", string3, string2));
        }
    }
}

