/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.util.concurrent.ConcurrentHashMap;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class ShutdownListener
extends RunListener {
    private final Result result = new Result();
    private final RunListener resultListener = this.result.createListener();
    private ConcurrentHashMap.KeySetView<Description, Boolean> currentDescriptions = ConcurrentHashMap.newKeySet();
    private RunListener underlying;

    public ShutdownListener(RunListener runListener) {
        this.underlying = runListener;
    }

    public void unexpectedShutdown() {
        for (Description description : this.currentDescriptions) {
            this.completeTestWithFailure(description);
        }
        try {
            this.resultListener.testRunFinished(this.result);
            this.underlying.testRunFinished(this.result);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void completeTestWithFailure(Description description) {
        Failure failure = new Failure(description, (Throwable)new UnknownError("Abnormal VM exit - test crashed. The test run may have timed out."));
        try {
            this.resultListener.testFailure(failure);
            this.resultListener.testFinished(description);
            this.underlying.testFailure(failure);
            this.underlying.testFinished(description);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testRunStarted(Description description) throws Exception {
        this.resultListener.testRunStarted(description);
    }

    public void testStarted(Description description) throws Exception {
        this.currentDescriptions.add(description);
        this.resultListener.testStarted(description);
    }

    public void testAssumptionFailure(Failure failure) {
        this.resultListener.testAssumptionFailure(failure);
    }

    public void testRunFinished(Result result) throws Exception {
        this.resultListener.testRunFinished(result);
    }

    public void testFinished(Description description) throws Exception {
        this.currentDescriptions.remove(description);
        this.resultListener.testFinished(description);
    }

    public void testFailure(Failure failure) throws Exception {
        this.resultListener.testFailure(failure);
    }

    public void testIgnored(Description description) throws Exception {
        this.resultListener.testIgnored(description);
    }
}

