/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.junit.runners.model.RunnerScheduler;
import org.pantsbuild.junit.annotations.TestParallel;
import org.pantsbuild.junit.annotations.TestSerial;
import org.pantsbuild.tools.junit.impl.Concurrency;

public class ConcurrentRunnerScheduler
implements RunnerScheduler {
    private final ExecutorService executor;
    private final Queue<Runnable> serialTasks;
    private final Concurrency defaultConcurrency;

    public ConcurrentRunnerScheduler(Concurrency concurrency, int n) {
        Preconditions.checkNotNull((Object)((Object)concurrency));
        this.defaultConcurrency = concurrency;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("concurrent-junit-runner-%d").build();
        this.executor = Executors.newFixedThreadPool(n, threadFactory);
        this.serialTasks = new ArrayDeque<Runnable>();
    }

    public void schedule(Runnable runnable) {
        if (this.shouldMethodsRunParallel()) {
            this.executor.execute(runnable);
        } else {
            this.serialTasks.offer(runnable);
        }
    }

    public void schedule(Runnable runnable, Class<?> clazz) {
        if (this.shouldClassRunParallel(clazz)) {
            this.executor.execute(runnable);
        } else {
            this.serialTasks.offer(runnable);
        }
    }

    private boolean shouldMethodsRunParallel() {
        return this.defaultConcurrency.shouldRunMethodsParallel();
    }

    private boolean shouldClassRunParallel(Class<?> clazz) {
        return !clazz.isAnnotationPresent(TestSerial.class) && (clazz.isAnnotationPresent(TestParallel.class) || this.defaultConcurrency.shouldRunClassesParallel());
    }

    public void finished() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            for (Runnable runnable : this.serialTasks) {
                runnable.run();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            this.executor.shutdownNow();
        }
    }
}

