/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;

public final class ScalaTestUtil {
    private static Class<?> suiteClass = null;
    private static Class<?> junitRunnerClass = null;

    private ScalaTestUtil() {
    }

    public static Runner getJUnitRunner(Class<?> clazz) throws Exception {
        return new ScalaTestJunitRunnerWrapper((Runner)junitRunnerClass.getConstructor(Class.class).newInstance(clazz));
    }

    public static boolean isScalaTestTest(Class<?> clazz) {
        return suiteClass != null && suiteClass.isAssignableFrom(clazz);
    }

    static {
        try {
            suiteClass = Class.forName("org.scalatest.Suite");
            junitRunnerClass = Class.forName("org.scalatest.junit.JUnitRunner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class ScalaTestJunitRunnerWrapper
    extends Runner
    implements Filterable {
        private final Runner delegate;

        private ScalaTestJunitRunnerWrapper(Runner runner) {
            this.delegate = runner;
        }

        public Description getDescription() {
            return this.delegate.getDescription();
        }

        public void run(RunNotifier runNotifier) {
            this.delegate.run(runNotifier);
        }

        public void filter(Filter filter) throws NoTestsRemainException {
            if (!filter.shouldRun(this.getDescription())) {
                throw new NoTestsRemainException();
            }
        }
    }
}

