/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl.experimental;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.runner.Computer;
import org.junit.runner.Runner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.RunnerScheduler;
import org.pantsbuild.tools.junit.impl.Concurrency;
import org.pantsbuild.tools.junit.impl.experimental.ConcurrentTestRunnerException;

public class ConcurrentComputer
extends Computer {
    private final Concurrency concurrency;
    private final int numParallelThreads;

    public ConcurrentComputer(Concurrency concurrency, int n) {
        Preconditions.checkNotNull((Object)((Object)concurrency));
        this.concurrency = concurrency;
        this.numParallelThreads = n > 0 ? n : 1;
    }

    private Runner parallelize(Runner runner) {
        if (runner instanceof ParentRunner) {
            ((ParentRunner)runner).setScheduler(new RunnerScheduler(){
                private final Map<Future<?>, Runnable> testResults = new HashMap();
                private final ExecutorService fService = Executors.newFixedThreadPool(ConcurrentComputer.access$000(ConcurrentComputer.this));

                public void schedule(Runnable runnable) {
                    this.testResults.put(this.fService.submit(runnable), runnable);
                }

                public void finished() {
                    try {
                        this.fService.shutdown();
                        boolean bl = this.fService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                        if (!bl) {
                            throw new ConcurrentTestRunnerException("Did not terminate all tests sucessfully.");
                        }
                        for (Future<?> future : this.testResults.keySet()) {
                            if (future.isDone()) {
                                try {
                                    future.get();
                                }
                                catch (ExecutionException executionException) {
                                    Throwables.propagate((Throwable)executionException);
                                }
                                continue;
                            }
                            if (future.isCancelled()) {
                                throw new ConcurrentTestRunnerException("Some tests did not run (cancelled)");
                            }
                            throw new ConcurrentTestRunnerException("Some tests did not run.");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace(System.err);
                    }
                }
            });
        }
        return runner;
    }

    public Runner getSuite(RunnerBuilder runnerBuilder, Class<?>[] classArray) throws InitializationError {
        Runner runner = super.getSuite(runnerBuilder, (Class[])classArray);
        return this.concurrency.shouldRunClassesParallel() ? this.parallelize(runner) : runner;
    }

    protected Runner getRunner(RunnerBuilder runnerBuilder, Class<?> clazz) throws Throwable {
        Runner runner = super.getRunner(runnerBuilder, clazz);
        return this.concurrency.shouldRunMethodsParallel() ? this.parallelize(runner) : runner;
    }

    static /* synthetic */ int access$000(ConcurrentComputer concurrentComputer) {
        return concurrentComputer.numParallelThreads;
    }
}

