/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import java.io.PrintStream;
import org.junit.internal.TextListener;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.pantsbuild.tools.junit.impl.Util;

class ConsoleListener
extends TextListener {
    private final PrintStream out;
    private boolean testsFinished;

    ConsoleListener(PrintStream printStream) {
        super(printStream);
        this.out = printStream;
        this.testsFinished = false;
    }

    public void testRunFinished(Result result) {
        super.testRunFinished(result);
        this.testsFinished = true;
    }

    public void testFailure(Failure failure) {
        if (this.testsFinished) {
            this.printFailure(failure, "Reported after run");
        } else {
            this.out.append(Util.isAssertionFailure(failure) ? (char)'F' : 'E');
        }
    }
}

