/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import org.pantsbuild.junit.annotations.TestParallel;
import org.pantsbuild.junit.annotations.TestParallelClassesAndMethods;
import org.pantsbuild.junit.annotations.TestParallelMethods;
import org.pantsbuild.junit.annotations.TestSerial;
import org.pantsbuild.tools.junit.impl.Concurrency;

class Spec {
    private final Class<?> clazz;
    private final ImmutableSet<String> methods;
    private final boolean hasCustomRunner;

    Spec(Class<?> clazz) {
        this(clazz, (ImmutableSet<String>)ImmutableSet.of());
    }

    private Spec(Class<?> clazz, ImmutableSet<String> immutableSet) {
        this(clazz, immutableSet, false);
    }

    private Spec(Class<?> clazz, ImmutableSet<String> immutableSet, boolean bl) {
        this.clazz = Objects.requireNonNull(clazz);
        this.methods = Objects.requireNonNull(immutableSet);
        this.hasCustomRunner = bl;
    }

    String getSpecName() {
        return this.clazz.getName();
    }

    Class<?> getSpecClass() {
        return this.clazz;
    }

    Spec withMethod(String string) {
        return new Spec(this.clazz, (ImmutableSet<String>)ImmutableSet.builder().addAll(this.methods).add((Object)string).build(), this.hasCustomRunner);
    }

    Concurrency getConcurrency(Concurrency concurrency) {
        if (this.clazz.isAnnotationPresent(TestSerial.class)) {
            return Concurrency.SERIAL;
        }
        if (this.clazz.isAnnotationPresent(TestParallel.class)) {
            return Concurrency.PARALLEL_CLASSES;
        }
        if (this.clazz.isAnnotationPresent(TestParallelMethods.class)) {
            return Concurrency.PARALLEL_METHODS;
        }
        if (this.clazz.isAnnotationPresent(TestParallelClassesAndMethods.class)) {
            return Concurrency.PARALLEL_CLASSES_AND_METHODS;
        }
        return concurrency;
    }

    public Collection<String> getMethods() {
        return this.methods;
    }

    public Spec asCustomRunnerSpec() {
        return new Spec(this.clazz, this.methods, true);
    }

    public boolean methodNameAllowedToNotMatch() {
        return this.hasCustomRunner;
    }

    public String toString() {
        return "Spec{clazz=" + this.clazz + ", methods=" + this.methods + ", hasCustomRunner=" + this.hasCustomRunner + '}';
    }
}

