/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.junit.runners.model.RunnerScheduler;
import org.pantsbuild.junit.annotations.TestParallel;
import org.pantsbuild.junit.annotations.TestSerial;

public class ConcurrentRunnerScheduler
implements RunnerScheduler {
    private final CompletionService<Void> completionService;
    private final Queue<Future<Void>> concurrentTasks;
    private final Queue<Runnable> serialTasks;
    private final boolean defaultParallel;
    private final boolean parallelMethods;

    public ConcurrentRunnerScheduler(boolean bl, boolean bl2, int n) {
        this.defaultParallel = bl;
        this.parallelMethods = bl2;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("concurrent-junit-runner-%d").build();
        this.completionService = new ExecutorCompletionService<Void>(Executors.newFixedThreadPool(n, threadFactory));
        this.concurrentTasks = new LinkedList<Future<Void>>();
        this.serialTasks = new LinkedList<Runnable>();
    }

    public void schedule(Runnable runnable) {
        if (this.shouldMethodsRunParallel()) {
            this.concurrentTasks.offer(this.completionService.submit(runnable, null));
        } else {
            this.serialTasks.offer(runnable);
        }
    }

    public void schedule(Runnable runnable, Class<?> clazz) {
        if (this.shouldClassRunParallel(clazz)) {
            this.concurrentTasks.offer(this.completionService.submit(runnable, null));
        } else {
            this.serialTasks.offer(runnable);
        }
    }

    private boolean shouldMethodsRunParallel() {
        return this.parallelMethods;
    }

    private boolean shouldClassRunParallel(Class<?> clazz) {
        return !clazz.isAnnotationPresent(TestSerial.class) && (clazz.isAnnotationPresent(TestParallel.class) || this.defaultParallel);
    }

    public void finished() {
        try {
            while (!this.concurrentTasks.isEmpty()) {
                this.concurrentTasks.poll().get();
            }
            for (Runnable runnable : this.serialTasks) {
                runnable.run();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw Throwables.propagate((Throwable)executionException.getCause());
        }
        finally {
            while (!this.concurrentTasks.isEmpty()) {
                this.concurrentTasks.poll().cancel(true);
            }
        }
    }
}

