/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.pantsbuild.tools.junit.impl.ForwardingListener;

abstract class AbortableListener
extends ForwardingListener {
    private final Result result = new Result();
    private final boolean failFast;
    private Description started;

    AbortableListener(boolean bl) {
        this.failFast = bl;
        this.addListener(this.result.createListener());
    }

    @Override
    public void testStarted(Description description) throws Exception {
        this.started = description;
        super.testStarted(description);
    }

    @Override
    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        if (this.failFast) {
            this.finish();
            this.abort(this.result);
        }
    }

    void abort(Throwable throwable) throws Exception {
        if (this.started != null) {
            super.testFailure(new Failure(this.started, throwable));
        }
        this.finish();
    }

    private void finish() throws Exception {
        this.testRunFinished(this.result);
    }

    protected abstract void abort(Result var1);
}

