/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.pantsbuild.junit.annotations.TestParallel;
import org.pantsbuild.junit.annotations.TestSerial;
import org.pantsbuild.tools.junit.impl.Concurrency;

class Spec {
    private final Class<?> clazz;
    private final Set<String> methods;

    public Spec(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        this.clazz = clazz;
        this.methods = new LinkedHashSet<String>();
    }

    public String getSpecName() {
        return this.clazz.getName();
    }

    public Class<?> getSpecClass() {
        return this.clazz;
    }

    public void addMethod(String string) {
        Preconditions.checkNotNull((Object)string);
        this.methods.add(string);
    }

    public Concurrency getConcurrency(Concurrency concurrency) {
        if (this.clazz.isAnnotationPresent(TestSerial.class)) {
            return Concurrency.SERIAL;
        }
        if (this.clazz.isAnnotationPresent(TestParallel.class)) {
            return Concurrency.PARALLEL_CLASSES;
        }
        return concurrency;
    }

    public Collection<String> getMethods() {
        return ImmutableList.copyOf(this.methods);
    }
}

