/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.junit.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.pantsbuild.tools.junit.impl.Spec;
import org.pantsbuild.tools.junit.impl.SpecException;

class SpecParser {
    private final Iterable<String> testSpecStrings;
    private final Map<Class<?>, Spec> specs = new LinkedHashMap();
    private final Set<String> classNamesInSpecs = new HashSet<String>();
    public static final Predicate<Constructor<?>> IS_PUBLIC_CONSTRUCTOR = new Predicate<Constructor<?>>(){

        public boolean apply(Constructor<?> constructor) {
            return Modifier.isPublic(constructor.getModifiers());
        }
    };
    private static final Predicate<Method> IS_ANNOTATED_TEST_METHOD = new Predicate<Method>(){

        public boolean apply(Method method) {
            return Modifier.isPublic(method.getModifiers()) && method.isAnnotationPresent(Test.class);
        }
    };

    public SpecParser(Iterable<String> iterable) {
        Preconditions.checkArgument((!Iterables.isEmpty(iterable) ? 1 : 0) != 0);
        this.testSpecStrings = iterable;
    }

    public List<Spec> parse() throws SpecException {
        for (String string : this.testSpecStrings) {
            if (string.indexOf(35) >= 0) {
                this.addMethod(string);
                continue;
            }
            if (this.classNamesInSpecs.contains(string)) {
                Spec spec = this.getOrCreateSpec(string, string);
                if (spec.getMethods().isEmpty()) continue;
                throw new SpecException(string, "Request for entire class already requesting individual methods");
            }
            this.getOrCreateSpec(string, string);
        }
        return ImmutableList.copyOf(this.specs.values());
    }

    private Spec getOrCreateSpec(String string, String string2) throws SpecException {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            if (!SpecParser.isTest(clazz)) {
                return null;
            }
            if (!this.specs.containsKey(clazz)) {
                this.specs.put(clazz, new Spec(clazz));
                this.classNamesInSpecs.add(string);
            }
            return this.specs.get(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SpecException(string2, String.format("Class %s not found in classpath.", string), classNotFoundException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new SpecException(string2, String.format("Class %s not found in classpath.", string), noClassDefFoundError);
        }
        catch (LinkageError linkageError) {
            throw new SpecException(string2, String.format("Error linking %s.", string), linkageError);
        }
        catch (RuntimeException runtimeException) {
            throw new SpecException(string2, String.format("Error initializing %s.", string), runtimeException);
        }
    }

    private static boolean isTest(Class<?> clazz) {
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) {
            return false;
        }
        if (!Iterables.any(Arrays.asList(clazz.getConstructors()), IS_PUBLIC_CONSTRUCTOR)) {
            return false;
        }
        if (junit.framework.Test.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.isAnnotationPresent(RunWith.class)) {
            return true;
        }
        return Iterables.any(Arrays.asList(clazz.getMethods()), IS_ANNOTATED_TEST_METHOD);
    }

    public void addMethod(String string) throws SpecException {
        String[] stringArray = string.split("#");
        if (stringArray.length != 2) {
            throw new SpecException(string, "Expected only one # in spec");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Spec spec = this.getOrCreateSpec(string2, string);
        boolean bl = false;
        for (Method method : spec.getSpecClass().getMethods()) {
            if (!method.getName().equals(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new SpecException(string, String.format("Method %s not found in class %s", string3, string2));
        }
        spec.addMethod(string3);
    }
}

