/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.compiler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.pantsbuild.tools.compiler.FilteredDiagnosticListener;

class AnsiColorDiagnosticListener<T extends FileObject>
extends FilteredDiagnosticListener<T> {
    private static final Pattern EOL = Pattern.compile("$", 8);
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private boolean colorOutput;
    private boolean includeSourceInfo;

    AnsiColorDiagnosticListener() {
        this(new PrintWriter(System.out), new PrintWriter(System.err));
    }

    AnsiColorDiagnosticListener(PrintWriter outWriter, PrintWriter errWriter) {
        this.outWriter = outWriter;
        this.errWriter = errWriter;
    }

    private static String getMessage(Diagnostic<? extends FileObject> diagnostic) {
        return diagnostic.getMessage(Locale.getDefault());
    }

    void setIncludeSourceInfo(boolean includeSourceInfo) {
        this.includeSourceInfo = includeSourceInfo;
    }

    void prepareConsole(boolean color) {
        this.colorOutput = color;
        if (color) {
            AnsiConsole.systemInstall();
        } else {
            System.setProperty(Ansi.DISABLE, "true");
        }
    }

    void releaseConsole() {
        if (this.colorOutput) {
            AnsiConsole.systemUninstall();
        } else {
            System.setProperty(Ansi.DISABLE, "false");
        }
    }

    @Override
    protected void reportOn(Diagnostic<? extends T> diagnostic) {
        switch (diagnostic.getKind()) {
            case NOTE: {
                this.logDiagnostic(this.outWriter, Ansi.ansi().fg(Ansi.Color.GREEN), diagnostic);
                break;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                this.logDiagnostic(this.errWriter, Ansi.ansi().fg(Ansi.Color.YELLOW), diagnostic);
                break;
            }
            case ERROR: {
                this.logDiagnostic(this.errWriter, Ansi.ansi().fg(Ansi.Color.RED), diagnostic);
                break;
            }
            default: {
                this.outWriter.println(AnsiColorDiagnosticListener.getMessage(diagnostic));
            }
        }
    }

    private void logDiagnostic(PrintWriter out, Ansi ansi, Diagnostic<? extends FileObject> diagnostic) {
        String message = AnsiColorDiagnosticListener.getMessage(diagnostic);
        CharSequence sourceCode = this.extractSource(diagnostic);
        if (sourceCode == null) {
            out.println(ansi.format("%s%s", new Object[]{this.includeSourceInfo ? this.kindMessage(diagnostic) : "", message}));
        } else {
            out.println(ansi.format("%s%s\n%s\n%s^", new Object[]{this.includeSourceInfo ? String.format("%s:%d: %s", diagnostic.getSource().toUri().getPath(), diagnostic.getLineNumber(), this.kindMessage(diagnostic)) : "", message, sourceCode, this.spaces((int)diagnostic.getColumnNumber() - 1)}));
        }
        out.print(Ansi.ansi().reset());
        out.flush();
    }

    private String kindMessage(Diagnostic<? extends FileObject> diagnostic) {
        return String.format("%s: ", diagnostic.getKind().name().toLowerCase());
    }

    private CharSequence extractSource(Diagnostic<? extends FileObject> diagnostic) {
        FileObject source = diagnostic.getSource();
        int startPosition = (int)diagnostic.getStartPosition();
        if (source == null || -1L == (long)startPosition || startPosition < 1) {
            return null;
        }
        try {
            CharSequence content = source.getCharContent(true);
            Matcher matcher = EOL.matcher(content);
            int endPosition = (int)diagnostic.getEndPosition();
            if (matcher.find(startPosition)) {
                endPosition = matcher.end();
            }
            if (startPosition == endPosition && startPosition > 0) {
                --startPosition;
            }
            while (startPosition > 0) {
                if (content.charAt(startPosition) == '\n' || content.charAt(startPosition) == '\r') {
                    ++startPosition;
                    break;
                }
                --startPosition;
            }
            return content.subSequence(startPosition, endPosition);
        }
        catch (IOException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private String spaces(int count) {
        char[] spaces = new char[count];
        Arrays.fill(spaces, ' ');
        return new String(spaces);
    }
}

