/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.pantsbuild.tools.compiler.AnsiColorDiagnosticListener;
import org.pantsbuild.tools.compiler.DependencyTrackingFileManager;
import org.pantsbuild.tools.compiler.DiagnosticFilters;
import org.pantsbuild.tools.compiler.FilteredDiagnosticListener;

public final class Compiler {
    public static final String DEPENDENCYFILE_FLAG = "-Tdependencyfile";
    public static final String COLOR_FLAG = "-Tcolor";
    public static final String WARN_IGNORE_PATH_PREFIXES = "-Tnowarnprefixes";
    public static final String WARN_IGNORE_MESSAGE_REGEX = "-Tnowarnregex";

    public static int compile(String[] args) {
        try {
            return Compiler.doCompile(args);
        }
        catch (Throwable t) {
            System.err.println("Unexpected compilation error:");
            t.printStackTrace(System.err);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doCompile(String[] args) throws IOException {
        AnsiColorDiagnosticListener diagnosticListener = new AnsiColorDiagnosticListener();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnosticListener, null, null);
        ArgParser argParser = new ArgParser(compiler, diagnosticListener, standardFileManager);
        try {
            argParser.parse(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        diagnosticListener.setIncludeSourceInfo(Compiler.getJavaVersion() >= 7);
        diagnosticListener.prepareConsole(argParser.isColor());
        try {
            int n;
            JavaFileManager fileManager = standardFileManager;
            File dependencyFile = argParser.getDependencyFile();
            if (dependencyFile != null) {
                fileManager = new DependencyTrackingFileManager(standardFileManager, dependencyFile);
            }
            try {
                JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, fileManager, diagnosticListener, argParser.getOptions(), null, standardFileManager.getJavaFileObjectsFromStrings(argParser.getCompilationUnits()));
                boolean success = compilationTask.call();
                n = success ? 0 : 1;
            }
            catch (Throwable throwable) {
                fileManager.close();
                throw throwable;
            }
            fileManager.close();
            return n;
        }
        finally {
            diagnosticListener.releaseConsole();
        }
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        String[] components = version.split("\\.", 3);
        return Integer.parseInt(components[1]);
    }

    public static void main(String[] args) {
        Compiler.exit(Compiler.compile(args));
    }

    private static void exit(int code) {
        System.exit(code);
    }

    static class ArgParser {
        private static final Set<Diagnostic.Kind> WARNING_KINDS = EnumSet.of(Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING);
        private static final DiagnosticFilters.Guard<Diagnostic<? extends FileObject>> IS_WARNING = new DiagnosticFilters.Guard<Diagnostic<? extends FileObject>>(){

            @Override
            public boolean permit(Diagnostic<? extends FileObject> diagnostic) {
                return WARNING_KINDS.contains((Object)diagnostic.getKind());
            }
        };
        private final JavaCompiler compiler;
        private final FilteredDiagnosticListener<? extends FileObject> diagnosticListener;
        private final StandardJavaFileManager standardFileManager;
        private final List<String> options = new ArrayList<String>();
        private final List<String> compilationUnits = new ArrayList<String>();
        private File dependencyFile;
        private boolean color;

        ArgParser(JavaCompiler compiler, FilteredDiagnosticListener<? extends FileObject> diagnosticListener, StandardJavaFileManager standardFileManager) {
            this.compiler = compiler;
            this.diagnosticListener = diagnosticListener;
            this.standardFileManager = standardFileManager;
        }

        void parse(String[] args) {
            ArrayList filters = new ArrayList();
            ArrayList<String> pathPrefixes = new ArrayList<String>();
            ArrayList<Pattern> messageRegexes = new ArrayList<Pattern>();
            Iterator<String> iter = Arrays.asList(args).iterator();
            while (iter.hasNext()) {
                String arg = iter.next();
                if (Compiler.DEPENDENCYFILE_FLAG.equals(arg)) {
                    this.parseDependencyFile(iter);
                    continue;
                }
                if (Compiler.COLOR_FLAG.equals(arg)) {
                    this.color = true;
                    continue;
                }
                if (Compiler.WARN_IGNORE_PATH_PREFIXES.equals(arg)) {
                    pathPrefixes.addAll(this.parsePrefixes(iter));
                    continue;
                }
                if (Compiler.WARN_IGNORE_MESSAGE_REGEX.equals(arg)) {
                    messageRegexes.add(this.parseRegex(iter));
                    continue;
                }
                if (arg.startsWith("-")) {
                    this.parsePassThroughOption(arg, iter);
                    continue;
                }
                this.compilationUnits.add(arg);
            }
            if (!pathPrefixes.isEmpty()) {
                filters.add(DiagnosticFilters.guarded(DiagnosticFilters.ignorePathPrefixes(pathPrefixes), IS_WARNING));
            }
            if (!messageRegexes.isEmpty()) {
                filters.add(DiagnosticFilters.guarded(DiagnosticFilters.ignoreMessagesMatching(messageRegexes), IS_WARNING));
            }
            if (!filters.isEmpty()) {
                this.diagnosticListener.setFilter(DiagnosticFilters.combine(filters));
            }
        }

        private void parseDependencyFile(Iterator<String> iter) {
            if (!iter.hasNext()) {
                throw new IllegalArgumentException(String.format("%s requires an argument specifying the output path", Compiler.DEPENDENCYFILE_FLAG));
            }
            this.dependencyFile = new File(iter.next());
        }

        private Collection<String> parsePrefixes(Iterator<String> iter) {
            if (!iter.hasNext()) {
                throw new IllegalArgumentException(String.format("%s requires an argument specifying path prefixes to ignore", Compiler.WARN_IGNORE_PATH_PREFIXES));
            }
            return Arrays.asList(iter.next().split(File.pathSeparator));
        }

        private Pattern parseRegex(Iterator<String> iter) {
            if (!iter.hasNext()) {
                throw new IllegalArgumentException(String.format("%s requires an argument specifying a warning message regex", Compiler.WARN_IGNORE_MESSAGE_REGEX));
            }
            return Pattern.compile(iter.next());
        }

        private void parsePassThroughOption(String arg, Iterator<String> iter) {
            int argCount = this.compiler.isSupportedOption(arg);
            if (argCount == -1) {
                argCount = this.standardFileManager.isSupportedOption(arg);
            }
            if (argCount == -1) {
                System.err.println("WARNING: Skipping unsupported option " + arg);
            } else {
                this.options.add(arg);
                while (argCount-- > 0) {
                    if (!iter.hasNext()) continue;
                    this.options.add(iter.next());
                }
            }
        }

        List<String> getOptions() {
            return this.options;
        }

        List<String> getCompilationUnits() {
            return this.compilationUnits;
        }

        File getDependencyFile() {
            return this.dependencyFile;
        }

        boolean isColor() {
            return this.color;
        }
    }
}

