/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

final class DependencyTrackingFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private final LinkedHashMap<String, List<String>> sourceToClasses = new LinkedHashMap();
    private final Set<String> priorSources = new HashSet<String>();
    private final File dependencyFile;
    private List<String> outputPath;
    private File outputDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DependencyTrackingFileManager(StandardJavaFileManager fileManager, File dependencies) throws IOException {
        super(fileManager);
        this.dependencyFile = dependencies;
        if (this.dependencyFile.exists()) {
            System.out.println("Reading existing dependency file at " + dependencies);
            BufferedReader dependencyReader = new BufferedReader(new FileReader(dependencies));
            try {
                String mapping;
                int line = 0;
                while ((mapping = dependencyReader.readLine()) != null) {
                    ++line;
                    String[] components = mapping.split(" -> ");
                    if (components.length != 2) {
                        System.err.printf("Ignoring malformed dependency in %s[%d]: %s\n", dependencies, line, mapping);
                        continue;
                    }
                    String sourceRelpath = components[0];
                    String classRelpath = components[1];
                    this.addMapping(sourceRelpath, classRelpath);
                }
            }
            finally {
                dependencyReader.close();
            }
        }
        this.priorSources.addAll(this.sourceToClasses.keySet());
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaFileObject file = super.getJavaFileForOutput(location, className, kind, sibling);
        if (JavaFileObject.Kind.CLASS == kind && sibling != null && sibling.toUri().getPath() != null) {
            this.addMapping(this.toOutputRelpath(sibling), this.toOutputRelpath(file));
        }
        return file;
    }

    private void addMapping(String sourceFile, String classFile) {
        List<String> classFiles = this.sourceToClasses.get(sourceFile);
        if (classFiles == null || this.priorSources.remove(sourceFile)) {
            classFiles = new ArrayList<String>();
            this.sourceToClasses.put(sourceFile, classFiles);
        }
        classFiles.add(classFile);
    }

    private String toOutputRelpath(FileObject file) {
        ArrayList<String> base = new ArrayList<String>(this.getOutputPath());
        List<String> path = this.toList(file);
        Iterator baseIter = base.iterator();
        Iterator<String> pathIter = path.iterator();
        while (baseIter.hasNext() && pathIter.hasNext() && ((String)baseIter.next()).equals(pathIter.next())) {
            baseIter.remove();
            pathIter.remove();
        }
        if (!base.isEmpty()) {
            path.addAll(0, Collections.nCopies(base.size(), ".."));
        }
        return this.join(path);
    }

    private String join(List<String> components) {
        StringBuilder path = new StringBuilder();
        int max = components.size();
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                path.append(File.separatorChar);
            }
            path.append(components.get(i));
        }
        return path.toString();
    }

    private List<String> toList(FileObject path) {
        return new ArrayList<String>(Arrays.asList(path.toUri().normalize().getPath().split("/")));
    }

    private synchronized List<String> getOutputPath() {
        if (this.outputPath == null) {
            ArrayList<String> components = new ArrayList<String>();
            for (File f = this.getOutputDir(); f != null; f = f.getParentFile()) {
                components.add(f.getName());
            }
            Collections.reverse(components);
            this.outputPath = components;
        }
        return this.outputPath;
    }

    private synchronized File getOutputDir() {
        if (this.outputDir == null) {
            Iterable<? extends File> location = ((StandardJavaFileManager)this.fileManager).getLocation(StandardLocation.CLASS_OUTPUT);
            if (location == null || !location.iterator().hasNext()) {
                throw new IllegalStateException("Expected to be called after compilation started - found no class output dir.");
            }
            for (File file : location) {
                if (this.outputDir != null) {
                    throw new IllegalStateException("Expected exactly 1 output path");
                }
                this.outputDir = file;
            }
        }
        return this.outputDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        System.out.println("Writing class dependency file to " + this.dependencyFile);
        PrintWriter dependencyWriter = new PrintWriter(new FileWriter(this.dependencyFile, false));
        try {
            for (Map.Entry<String, List<String>> entry : this.sourceToClasses.entrySet()) {
                String sourceFile = entry.getKey();
                for (String classFile : entry.getValue()) {
                    if (this.priorSources.contains(sourceFile) && !this.doesMappingExist(sourceFile, classFile)) continue;
                    dependencyWriter.printf("%s -> %s\n", sourceFile, classFile);
                }
            }
        }
        finally {
            dependencyWriter.close();
        }
    }

    private boolean doesMappingExist(String sourceFile, String classFile) {
        return new File(this.getOutputDir(), sourceFile).exists() && new File(this.getOutputDir(), classFile).exists();
    }
}

