/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.compiler;

import java.util.Locale;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.FileObject;

final class DiagnosticFilters {
    static final DiagnosticFilter<Object> STRAIGHT_MAPPING = new DiagnosticFilter<Object>(){

        @Override
        public Treatment categorize(Diagnostic<?> diagnostic) {
            Treatment treatment;
            switch (diagnostic.getKind()) {
                case NOTE: {
                    treatment = Treatment.NOTE;
                    break;
                }
                case WARNING: {
                    treatment = Treatment.WARNING;
                    break;
                }
                case MANDATORY_WARNING: {
                    treatment = Treatment.MANDATORY_WARNING;
                    break;
                }
                case ERROR: {
                    treatment = Treatment.ERROR;
                    break;
                }
                default: {
                    treatment = Treatment.OTHER;
                }
            }
            return treatment;
        }
    };

    private DiagnosticFilters() {
    }

    static <S> DiagnosticFilter<S> combine(final Iterable<? extends DiagnosticFilter<? super S>> filters) {
        return new DiagnosticFilter<S>(){

            @Override
            public Treatment categorize(Diagnostic<? extends S> diagnostic) {
                for (DiagnosticFilter filter : filters) {
                    Treatment treatment = filter.categorize(diagnostic);
                    if (Treatment.PASS == treatment) continue;
                    return treatment;
                }
                return STRAIGHT_MAPPING.categorize(diagnostic);
            }
        };
    }

    static <T extends FileObject> DiagnosticFilter<T> guarded(final DiagnosticFilter<T> guarded, final Guard<Diagnostic<? extends T>> guard) {
        return new DiagnosticFilter<T>(){

            @Override
            public Treatment categorize(Diagnostic<? extends T> diagnostic) {
                return guard.permit(diagnostic) ? guarded.categorize(diagnostic) : Treatment.PASS;
            }
        };
    }

    static <T extends FileObject> DiagnosticFilter<T> ignorePathPrefixes(final Iterable<String> pathPrefixes) {
        return new DiagnosticFilter<T>(){

            @Override
            public Treatment categorize(Diagnostic<? extends T> diagnostic) {
                String path;
                FileObject source = (FileObject)diagnostic.getSource();
                if (source != null && (path = source.toUri().getPath()) != null) {
                    for (String pathPrefix : pathPrefixes) {
                        if (!path.startsWith(pathPrefix)) continue;
                        return Treatment.IGNORE;
                    }
                }
                return Treatment.PASS;
            }
        };
    }

    static <T extends FileObject> DiagnosticFilter<T> ignoreMessagesMatching(final Iterable<Pattern> regexes) {
        return new DiagnosticFilter<T>(){

            @Override
            public Treatment categorize(Diagnostic<? extends T> diagnostic) {
                String message = diagnostic.getMessage(Locale.getDefault());
                for (Pattern regex : regexes) {
                    if (!regex.matcher(message).matches()) continue;
                    return Treatment.IGNORE;
                }
                return Treatment.PASS;
            }
        };
    }

    static interface Guard<T> {
        public boolean permit(T var1);
    }

    static interface DiagnosticFilter<T> {
        public Treatment categorize(Diagnostic<? extends T> var1);
    }

    public static enum Treatment {
        NOTE,
        WARNING,
        MANDATORY_WARNING,
        ERROR,
        OTHER,
        IGNORE,
        PASS;

    }
}

