/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.compiler;

import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import org.pantsbuild.tools.compiler.DiagnosticFilters;

abstract class FilteredDiagnosticListener<T>
implements DiagnosticListener<T> {
    private volatile DiagnosticFilters.DiagnosticFilter<? super T> filter = DiagnosticFilters.STRAIGHT_MAPPING;

    FilteredDiagnosticListener() {
    }

    void setFilter(final DiagnosticFilters.DiagnosticFilter<? super T> filter) {
        if (filter == null) {
            throw new NullPointerException("The filter cannot be null.");
        }
        this.filter = new DiagnosticFilters.DiagnosticFilter<T>(){

            @Override
            public DiagnosticFilters.Treatment categorize(Diagnostic<? extends T> diagnostic) {
                DiagnosticFilters.Treatment treatment = filter.categorize(diagnostic);
                if (DiagnosticFilters.Treatment.PASS != treatment) {
                    return treatment;
                }
                return DiagnosticFilters.STRAIGHT_MAPPING.categorize(diagnostic);
            }
        };
    }

    @Override
    public final void report(Diagnostic<? extends T> diagnostic) {
        DiagnosticFilters.Treatment treatment = this.filter.categorize(diagnostic);
        switch (treatment) {
            case IGNORE: {
                break;
            }
            case NOTE: {
                this.reportOn(new FilteredDiagnostic(Diagnostic.Kind.NOTE, diagnostic));
                break;
            }
            case WARNING: {
                this.reportOn(new FilteredDiagnostic(Diagnostic.Kind.WARNING, diagnostic));
                break;
            }
            case MANDATORY_WARNING: {
                this.reportOn(new FilteredDiagnostic(Diagnostic.Kind.MANDATORY_WARNING, diagnostic));
                break;
            }
            case ERROR: {
                this.reportOn(new FilteredDiagnostic(Diagnostic.Kind.ERROR, diagnostic));
                break;
            }
            default: {
                this.reportOn(new FilteredDiagnostic(Diagnostic.Kind.OTHER, diagnostic));
            }
        }
    }

    protected abstract void reportOn(Diagnostic<? extends T> var1);

    class FilteredDiagnostic
    implements Diagnostic<T> {
        private final Diagnostic.Kind filteredKind;
        private final Diagnostic<? extends T> delegate;

        FilteredDiagnostic(Diagnostic.Kind filteredKind, Diagnostic<? extends T> delegate) {
            this.filteredKind = filteredKind;
            this.delegate = delegate;
        }

        @Override
        public Diagnostic.Kind getKind() {
            return this.filteredKind;
        }

        @Override
        public T getSource() {
            return this.delegate.getSource();
        }

        @Override
        public long getPosition() {
            return this.delegate.getPosition();
        }

        @Override
        public long getStartPosition() {
            return this.delegate.getStartPosition();
        }

        @Override
        public long getEndPosition() {
            return this.delegate.getEndPosition();
        }

        @Override
        public long getLineNumber() {
            return this.delegate.getLineNumber();
        }

        @Override
        public long getColumnNumber() {
            return this.delegate.getColumnNumber();
        }

        @Override
        public String getCode() {
            return this.delegate.getCode();
        }

        @Override
        public String getMessage(Locale locale) {
            return this.delegate.getMessage(locale);
        }
    }
}

