/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.zinc.compiler;

import java.util.Properties;
import org.pantsbuild.zinc.analysis.AnalysisMap;
import org.pantsbuild.zinc.analysis.AnalysisMap$;
import org.pantsbuild.zinc.compiler.InputUtils$;
import org.pantsbuild.zinc.compiler.Main;
import org.pantsbuild.zinc.compiler.Settings;
import org.pantsbuild.zinc.compiler.Settings$;
import org.pantsbuild.zinc.options.Parsed;
import org.pantsbuild.zinc.util.Util$;
import sbt.internal.inc.ConcreteAnalysisContents;
import sbt.internal.inc.IncrementalCompilerImpl;
import sbt.internal.util.ConsoleLogger;
import sbt.internal.util.ConsoleLogger$;
import sbt.internal.util.ConsoleOut$;
import sbt.util.Level$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.sys.package$;
import xsbti.CompileFailed;
import xsbti.Logger;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileResult;
import xsbti.compile.Inputs;
import xsbti.compile.PreviousResult;

public final class Main$ {
    public static final Main$ MODULE$;
    private final String Command;
    private final String Description;
    private Main.Version zincVersion;
    private String versionString;
    private volatile byte bitmap$0;

    static {
        new Main$();
    }

    private Main.Version zincVersion$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Properties props = Util$.MODULE$.propertiesFromResource("zinc.version.properties", this.getClass().getClassLoader());
                this.zincVersion = new Main.Version(props.getProperty("version", "unknown"), props.getProperty("timestamp", ""), props.getProperty("commit", ""));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.zincVersion;
        }
    }

    private String versionString$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.versionString = this.zincVersion().published().endsWith("-SNAPSHOT") ? new StringOps(Predef$.MODULE$.augmentString("%s %s-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zincVersion().published(), this.zincVersion().timestamp(), new StringOps(Predef$.MODULE$.augmentString(this.zincVersion().commit())).take(10)})) : this.zincVersion().published();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.versionString;
        }
    }

    public String Command() {
        return this.Command;
    }

    public String Description() {
        return this.Description;
    }

    public Main.Version zincVersion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.zincVersion$lzycompute() : this.zincVersion;
    }

    public String versionString() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.versionString$lzycompute() : this.versionString;
    }

    public void printVersion() {
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s (%s) %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.Command(), this.Description(), this.versionString()})));
    }

    /*
     * WARNING - void declaration
     */
    public ConsoleLogger mkLogger(Settings settings) {
        void var2_2;
        ConsoleLogger cl = ConsoleLogger$.MODULE$.apply(ConsoleOut$.MODULE$.systemOut(), settings.consoleLog().color(), ConsoleLogger$.MODULE$.apply$default$3(), ConsoleLogger$.MODULE$.apply$default$4());
        cl.setLevel(settings.consoleLog().logLevel());
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        Tuple2 tuple22;
        Tuple3 tuple3;
        long startTime = System.currentTimeMillis();
        Parsed<Settings> parsed = Settings$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (parsed == null) throw new MatchError(parsed);
        Settings settings = (Settings)parsed.context();
        Seq residual = parsed.remaining();
        Seq errors = parsed.errors();
        Tuple3 tuple32 = tuple3 = new Tuple3((Object)settings, (Object)residual, (Object)errors);
        Settings settings2 = (Settings)tuple32._1();
        Seq residual2 = (Seq)tuple32._2();
        Seq errors2 = (Seq)tuple32._3();
        ConsoleLogger log = this.mkLogger(settings2);
        boolean isDebug = settings2.consoleLog().logLevel().$less$eq((Object)Level$.MODULE$.Debug());
        if (errors2.nonEmpty()) {
            errors2.foreach((Function1)new Serializable(log){
                public static final long serialVersionUID = 0L;
                private final ConsoleLogger log$1;

                public final void apply(String error) {
                    this.log$1.error((Function0)new Serializable(this, error){
                        public static final long serialVersionUID = 0L;
                        private final String error$1;

                        public final String apply() {
                            return this.error$1;
                        }
                        {
                            this.error$1 = error$1;
                        }
                    });
                }
                {
                    this.log$1 = log$1;
                }
            });
            log.error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("See %s -help for information about options")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Main$.MODULE$.Command()}));
                }
            });
            throw package$.MODULE$.exit(1);
        }
        if (settings2.version()) {
            this.printVersion();
        }
        if (settings2.help()) {
            Settings$.MODULE$.printUsage(this.Command(), "<sources>");
        }
        if (settings2.sources().isEmpty()) {
            if (settings2.version() || settings2.help()) {
                throw package$.MODULE$.exit(0);
            }
            this.printVersion();
            Settings$.MODULE$.printUsage(this.Command(), Settings$.MODULE$.printUsage$default$2());
            throw package$.MODULE$.exit(1);
        }
        AnalysisMap analysisMap = AnalysisMap$.MODULE$.create(settings2.analysis());
        Tuple2<AnalysisStore, PreviousResult> tuple2 = InputUtils$.MODULE$.loadDestinationAnalysis(settings2, analysisMap, (sbt.util.Logger)log);
        if (tuple2 == null) throw new MatchError(tuple2);
        AnalysisStore targetAnalysisStore = (AnalysisStore)tuple2._1();
        PreviousResult previousResult = (PreviousResult)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)targetAnalysisStore, (Object)previousResult);
        AnalysisStore targetAnalysisStore2 = (AnalysisStore)tuple23._1();
        PreviousResult previousResult2 = (PreviousResult)tuple23._2();
        Inputs inputs = InputUtils$.MODULE$.create(settings2, analysisMap, previousResult2, (sbt.util.Logger)log);
        if (isDebug) {
            log.debug((Function0)new Serializable(inputs){
                public static final long serialVersionUID = 0L;
                private final Inputs inputs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inputs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.inputs$1}));
                }
                {
                    this.inputs$1 = inputs$1;
                }
            });
        }
        try {
            CompileResult result = new IncrementalCompilerImpl().compile(inputs, (Logger)log);
            if (result.hasModified()) {
                targetAnalysisStore2.set((AnalysisContents)new ConcreteAnalysisContents(result.analysis(), result.setup()));
            }
            log.info((Function0)new Serializable(startTime){
                public static final long serialVersionUID = 0L;
                private final long startTime$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Compile success ").append((Object)Util$.MODULE$.timing(this.startTime$1)).toString();
                }
                {
                    this.startTime$1 = startTime$1;
                }
            });
            return;
        }
        catch (Exception exception) {
            String message;
            if (isDebug) {
                exception.printStackTrace();
            }
            if ((message = exception.getMessage()) == null) throw package$.MODULE$.exit(1);
            log.error((Function0)new Serializable(message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            throw package$.MODULE$.exit(1);
        }
        catch (CompileFailed compileFailed) {
            log.error((Function0)new Serializable(startTime){
                public static final long serialVersionUID = 0L;
                private final long startTime$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Compile failed ").append((Object)Util$.MODULE$.timing(this.startTime$1)).toString();
                }
                {
                    this.startTime$1 = startTime$1;
                }
            });
            throw package$.MODULE$.exit(1);
        }
    }

    private Main$() {
        MODULE$ = this;
        this.Command = "zinc-compiler";
        this.Description = "scala incremental compiler";
    }
}

