/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.zinc.compiler;

import com.google.common.cache.Cache;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.pantsbuild.zinc.cache.Cache$;
import org.pantsbuild.zinc.compiler.CompilerCacheKey;
import org.pantsbuild.zinc.compiler.CompilerCacheKey$;
import org.pantsbuild.zinc.compiler.Settings;
import org.pantsbuild.zinc.util.Util$;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.AnalyzingCompiler$;
import sbt.internal.inc.RawCompiler;
import sbt.internal.inc.ScalaInstance;
import sbt.internal.inc.ZincUtil$;
import sbt.internal.inc.classpath.ClassLoaderCache;
import sbt.internal.inc.classpath.ClasspathUtilities$;
import sbt.io.Path$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import xsbti.compile.ClasspathOptionsUtil;
import xsbti.compile.CompilerCache;
import xsbti.compile.Compilers;
import xsbti.compile.GlobalsCache;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.ZincCompilerUtil;

public final class CompilerUtils$ {
    public static final CompilerUtils$ MODULE$;
    private final String CompilerInterfaceId;
    private final String JavaClassVersion;
    private final int compilerCacheLimit;
    private final int residentCacheLimit;
    private final Cache<CompilerCacheKey, Compilers> compilerCache;
    private final GlobalsCache residentCache;
    private final Option<ClassLoaderCache> classLoaderCache;

    static {
        new CompilerUtils$();
    }

    public String CompilerInterfaceId() {
        return this.CompilerInterfaceId;
    }

    public String JavaClassVersion() {
        return this.JavaClassVersion;
    }

    private int compilerCacheLimit() {
        return this.compilerCacheLimit;
    }

    private int residentCacheLimit() {
        return this.residentCacheLimit;
    }

    private Cache<CompilerCacheKey, Compilers> compilerCache() {
        return this.compilerCache;
    }

    private GlobalsCache residentCache() {
        return this.residentCache;
    }

    private Option<ClassLoaderCache> classLoaderCache() {
        return this.classLoaderCache;
    }

    public Compilers getOrCreate(Settings settings, Logger log) {
        CompilerCacheKey setup = CompilerCacheKey$.MODULE$.apply(settings);
        return (Compilers)Cache$.MODULE$.Implicits(this.compilerCache()).getOrElseUpdate((Object)setup, (Function0)new Serializable(log, setup){
            public static final long serialVersionUID = 0L;
            private final Logger log$1;
            private final CompilerCacheKey setup$1;

            public final Compilers apply() {
                xsbti.compile.ScalaInstance instance = CompilerUtils$.MODULE$.scalaInstance(this.setup$1);
                File interfaceJar = CompilerUtils$.MODULE$.compilerInterface(this.setup$1, instance, this.log$1);
                AnalyzingCompiler scalac = CompilerUtils$.MODULE$.newScalaCompiler(instance, interfaceJar);
                return ZincUtil$.MODULE$.compilers(instance, ClasspathOptionsUtil.auto(), this.setup$1.javaHome(), (ScalaCompiler)scalac);
            }
            {
                this.log$1 = log$1;
                this.setup$1 = setup$1;
            }
        });
    }

    public GlobalsCache getGlobalsCache() {
        return this.residentCache();
    }

    public AnalyzingCompiler newScalaCompiler(xsbti.compile.ScalaInstance instance, File interfaceJar) {
        return new AnalyzingCompiler(instance, ZincCompilerUtil.constantBridgeProvider((xsbti.compile.ScalaInstance)instance, (File)interfaceJar), ClasspathOptionsUtil.auto(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<String> x$1) {
            }
        }, this.classLoaderCache());
    }

    public xsbti.compile.ScalaInstance scalaInstance(CompilerCacheKey setup) {
        File file = setup.scalaLibrary();
        File file2 = setup.scalaCompiler();
        Seq allJars = (Seq)((SeqLike)setup.scalaExtra().$plus$colon((Object)file2, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)file, Seq$.MODULE$.canBuildFrom());
        URLClassLoader loader = this.scalaLoader((Seq<File>)allJars);
        Option<String> version = this.scalaVersion(loader);
        return new ScalaInstance((String)version.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unknown";
            }
        }), (ClassLoader)loader, setup.scalaLibrary(), setup.scalaCompiler(), (File[])allJars.toArray(ClassTag$.MODULE$.apply(File.class)), version);
    }

    public URLClassLoader scalaLoader(Seq<File> jars) {
        return new URLClassLoader(Path$.MODULE$.toURLs(jars), ClasspathUtilities$.MODULE$.rootLoader());
    }

    public Option<String> scalaVersion(ClassLoader scalaLoader) {
        return Util$.MODULE$.propertyFromResource("compiler.properties", "version.number", scalaLoader);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File compilerInterface(CompilerCacheKey setup, xsbti.compile.ScalaInstance scalaInstance2, Logger log) {
        boolean bl;
        Object object;
        File dir = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(setup.cacheDir()), this.interfaceId(scalaInstance2.actualVersion()));
        File interfaceJar = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(dir), new StringBuilder().append((Object)this.CompilerInterfaceId()).append((Object)".jar").toString());
        if (interfaceJar.isFile()) {
            object = BoxedUnit.UNIT;
            return interfaceJar;
        }
        dir.mkdirs();
        File tempJar = File.createTempFile("interface-", ".jar.tmp", dir);
        try {
            this.compile$1(tempJar, setup, scalaInstance2, log);
            bl = tempJar.renameTo(interfaceJar);
            tempJar.delete();
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.delete();
            throw throwable;
        }
        object = BoxesRunTime.boxToBoolean((boolean)bl);
        return interfaceJar;
    }

    public String interfaceId(String scalaVersion) {
        return new StringBuilder().append((Object)this.CompilerInterfaceId()).append((Object)"-").append((Object)scalaVersion).append((Object)"-").append((Object)this.JavaClassVersion()).toString();
    }

    private final void compile$1(File targetJar, CompilerCacheKey setup$2, xsbti.compile.ScalaInstance scalaInstance$1, Logger log$2) {
        AnalyzingCompiler$.MODULE$.compileSources((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{setup$2.compilerBridgeSrc()})), targetJar, (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{setup$2.compilerInterface()})), this.CompilerInterfaceId(), new RawCompiler(scalaInstance$1, ClasspathOptionsUtil.auto(), log$2), log$2);
    }

    private CompilerUtils$() {
        MODULE$ = this;
        this.CompilerInterfaceId = "compiler-interface";
        this.JavaClassVersion = System.getProperty("java.class.version");
        this.compilerCacheLimit = Util$.MODULE$.intProperty("zinc.compiler.cache.limit", 5);
        this.residentCacheLimit = Util$.MODULE$.intProperty("zinc.resident.cache.limit", 0);
        this.compilerCache = Cache$.MODULE$.apply(this.compilerCacheLimit());
        int maxCompilers = this.residentCacheLimit();
        this.residentCache = maxCompilers <= 0 ? CompilerCache.fresh() : CompilerCache.createCacheFor((int)maxCompilers);
        this.classLoaderCache = new Some((Object)new ClassLoaderCache((ClassLoader)new URLClassLoader((URL[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(URL.class)))));
    }
}

