/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.zinc.compiler;

import com.martiansoftware.nailgun.NGContext;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.pantsbuild.zinc.analysis.AnalysisMap;
import org.pantsbuild.zinc.analysis.AnalysisMap$;
import org.pantsbuild.zinc.compiler.InputUtils$;
import org.pantsbuild.zinc.compiler.Main;
import org.pantsbuild.zinc.compiler.OutputUtils$;
import org.pantsbuild.zinc.compiler.Settings;
import org.pantsbuild.zinc.compiler.Settings$;
import org.pantsbuild.zinc.options.Parsed;
import org.pantsbuild.zinc.util.Util$;
import sbt.internal.inc.ConcreteAnalysisContents;
import sbt.internal.inc.IncrementalCompilerImpl;
import sbt.internal.util.ConsoleLogger;
import sbt.internal.util.ConsoleLogger$;
import sbt.internal.util.ConsoleOut$;
import sbt.util.Level$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import xsbti.CompileFailed;
import xsbti.Logger;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileResult;
import xsbti.compile.Inputs;
import xsbti.compile.PreviousResult;

public final class Main$ {
    public static Main$ MODULE$;
    private Main.Version zincVersion;
    private String versionString;
    private final String Command;
    private final String Description;
    private volatile byte bitmap$0;

    static {
        new Main$();
    }

    public String Command() {
        return this.Command;
    }

    public String Description() {
        return this.Description;
    }

    private Main.Version zincVersion$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Properties props = Util$.MODULE$.propertiesFromResource("zinc.version.properties", this.getClass().getClassLoader());
                this.zincVersion = new Main.Version(props.getProperty("version", "unknown"), props.getProperty("timestamp", ""), props.getProperty("commit", ""));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.zincVersion;
    }

    public Main.Version zincVersion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.zincVersion$lzycompute() : this.zincVersion;
    }

    private String versionString$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.versionString = this.zincVersion().published().endsWith("-SNAPSHOT") ? new StringOps(Predef$.MODULE$.augmentString("%s %s-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zincVersion().published(), this.zincVersion().timestamp(), new StringOps(Predef$.MODULE$.augmentString(this.zincVersion().commit())).take(10)})) : this.zincVersion().published();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.versionString;
    }

    public String versionString() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.versionString$lzycompute() : this.versionString;
    }

    public void printVersion() {
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s (%s) %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.Command(), this.Description(), this.versionString()})));
    }

    /*
     * WARNING - void declaration
     */
    public ConsoleLogger mkLogger(Settings settings) {
        void var2_2;
        if (!Util$.MODULE$.isSetProperty("log4j2.disable.jmx")) {
            Util$.MODULE$.setProperty("log4j2.disable.jmx", "true");
        }
        System.setProperty("sbt.log.format", "true");
        ConsoleLogger cl = ConsoleLogger$.MODULE$.apply(ConsoleOut$.MODULE$.systemOut(), settings.consoleLog().color(), ConsoleLogger$.MODULE$.apply$default$3(), ConsoleLogger$.MODULE$.apply$default$4());
        cl.setLevel(settings.consoleLog().logLevel());
        return var2_2;
    }

    public void main(String[] args) {
        long startTime = System.currentTimeMillis();
        Parsed<Settings> parsed = Settings$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (parsed == null) {
            throw new MatchError(parsed);
        }
        Settings settings = (Settings)parsed.context();
        Seq residual = parsed.remaining();
        Seq errors = parsed.errors();
        Tuple3 tuple3 = new Tuple3((Object)settings, (Object)residual, (Object)errors);
        Tuple3 tuple32 = tuple3;
        Settings settings2 = (Settings)tuple32._1();
        Seq residual2 = (Seq)tuple32._2();
        Seq errors2 = (Seq)tuple32._3();
        this.mainImpl(settings2.withAbsolutePaths(Paths.get(".", new String[0]).toAbsolutePath().toFile()), (Seq<String>)errors2, startTime);
    }

    public void nailMain(NGContext context) {
        long startTime = System.currentTimeMillis();
        Parsed<Settings> parsed = Settings$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])context.getArgs()));
        if (parsed == null) {
            throw new MatchError(parsed);
        }
        Settings settings = (Settings)parsed.context();
        Seq residual = parsed.remaining();
        Seq errors = parsed.errors();
        Tuple3 tuple3 = new Tuple3((Object)settings, (Object)residual, (Object)errors);
        Tuple3 tuple32 = tuple3;
        Settings settings2 = (Settings)tuple32._1();
        Seq residual2 = (Seq)tuple32._2();
        Seq errors2 = (Seq)tuple32._3();
        this.mainImpl(settings2.withAbsolutePaths(new File(context.getWorkingDirectory())), (Seq<String>)errors2, startTime);
    }

    public void mainImpl(Settings settings, Seq<String> errors, long startTime) {
        ConsoleLogger log = this.mkLogger(settings);
        boolean isDebug = settings.consoleLog().logLevel().$less$eq((Object)Level$.MODULE$.Debug());
        if (errors.nonEmpty()) {
            errors.foreach((Function1 & Serializable & scala.Serializable)error -> {
                log.error((Function0 & Serializable & scala.Serializable)() -> error);
                return BoxedUnit.UNIT;
            });
            log.error((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("See %s -help for information about options")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.Command()})));
            throw package$.MODULE$.exit(1);
        }
        if (settings.version()) {
            this.printVersion();
        }
        if (settings.help()) {
            Settings$.MODULE$.printUsage(this.Command(), "<sources>");
        }
        if (settings.sources().isEmpty()) {
            if (!settings.version() && !settings.help()) {
                this.printVersion();
                Settings$.MODULE$.printUsage(this.Command(), Settings$.MODULE$.printUsage$default$2());
                throw package$.MODULE$.exit(1);
            }
            throw package$.MODULE$.exit(0);
        }
        AnalysisMap analysisMap = AnalysisMap$.MODULE$.create(settings.analysis());
        Tuple2<AnalysisStore, PreviousResult> tuple2 = InputUtils$.MODULE$.loadDestinationAnalysis(settings, analysisMap, (sbt.util.Logger)log);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        AnalysisStore targetAnalysisStore = (AnalysisStore)tuple2._1();
        PreviousResult previousResult = (PreviousResult)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetAnalysisStore, (Object)previousResult);
        Tuple2 tuple23 = tuple22;
        AnalysisStore targetAnalysisStore2 = (AnalysisStore)tuple23._1();
        PreviousResult previousResult2 = (PreviousResult)tuple23._2();
        Inputs inputs = InputUtils$.MODULE$.create(settings, analysisMap, previousResult2, (sbt.util.Logger)log);
        if (isDebug) {
            log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Inputs: ").append(inputs).toString());
        }
        try {
            CompileResult result = new IncrementalCompilerImpl().compile(inputs, (Logger)log);
            if (result.hasModified()) {
                targetAnalysisStore2.set((AnalysisContents)new ConcreteAnalysisContents(result.analysis(), result.setup()));
            }
            log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Compile success ").append(Util$.MODULE$.timing(startTime)).toString());
            if (settings.outputJar().isDefined()) {
                Path outputJarPath = ((File)settings.outputJar().get()).toPath();
                File classesDirectory = settings.classesDirectory();
                log.debug((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Creating JAR at %s, for files at %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputJarPath, classesDirectory})));
                OutputUtils$.MODULE$.createClassesJar(classesDirectory, outputJarPath, settings.creationTime());
            }
        }
        catch (CompileFailed e) {
            log.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Compile failed ").append(Util$.MODULE$.timing(startTime)).toString());
            throw package$.MODULE$.exit(1);
        }
        catch (Exception e) {
            String message;
            if (isDebug) {
                e.printStackTrace();
            }
            if ((message = e.getMessage()) != null) {
                log.error((Function0 & Serializable & scala.Serializable)() -> message);
            }
            throw package$.MODULE$.exit(1);
        }
    }

    private Main$() {
        MODULE$ = this;
        this.Command = "zinc-compiler";
        this.Description = "scala incremental compiler";
    }
}

