/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.zinc.compiler;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import org.pantsbuild.zinc.analysis.AnalysisMap;
import org.pantsbuild.zinc.compiler.BareBonesLogger;
import org.pantsbuild.zinc.compiler.CompilerUtils$;
import org.pantsbuild.zinc.compiler.InputUtils;
import org.pantsbuild.zinc.compiler.InputUtils$Defaults$;
import org.pantsbuild.zinc.compiler.InputUtils$JarFile$;
import org.pantsbuild.zinc.compiler.ScalaLocation;
import org.pantsbuild.zinc.compiler.Settings;
import org.pantsbuild.zinc.scalautil.ScalaUtils$;
import sbt.internal.inc.ReporterManager$;
import sbt.internal.inc.ZincUtil$;
import sbt.io.IO$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import xsbti.Position;
import xsbti.Reporter;
import xsbti.ReporterConfig;
import xsbti.ReporterUtil;
import xsbti.T2;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.ClasspathOptionsUtil;
import xsbti.compile.CompileOptions;
import xsbti.compile.Compilers;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.Inputs;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.PreviousResult;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.ScalaInstance;
import xsbti.compile.Setup;

public final class InputUtils$ {
    public static InputUtils$ MODULE$;
    private final InputUtils.JarFile ScalaCompiler;
    private final InputUtils.JarFile ScalaLibrary;
    private final InputUtils.JarFile ScalaReflect;

    static {
        new InputUtils$();
    }

    public Inputs create(Settings settings, AnalysisMap analysisMap, PreviousResult previousResult, Logger log) {
        InputUtils.ScalaJars scalaJars = this.selectScalaJars(settings.scala());
        ScalaInstance instance = ScalaUtils$.MODULE$.scalaInstance(scalaJars.compiler(), scalaJars.extra(), scalaJars.library());
        Compilers compilers = ZincUtil$.MODULE$.compilers(instance, ClasspathOptionsUtil.auto(), settings.javaHome(), (ScalaCompiler)CompilerUtils$.MODULE$.newScalaCompiler(instance, (File)settings.compiledBridgeJar().get()));
        Function<Position, Position> positionMapper = new Function<Position, Position>(){

            public <V> Function<V, Position> compose(Function<? super V, ? extends Position> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Position, V> andThen(Function<? super Position, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Position apply(Position p) {
                return p;
            }
        };
        CompileOptions compileOptions = CompileOptions.create().withClasspath((File[])this.autoClasspath(settings.classesDirectory(), (Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])compilers.scalac().scalaInstance().allJars()), settings.javaOnly(), settings.classpath()).toArray(ClassTag$.MODULE$.apply(File.class))).withSources((File[])settings.sources().toArray(ClassTag$.MODULE$.apply(File.class))).withClassesDirectory(settings.classesDirectory()).withScalacOptions((String[])settings.scalacOptions().toArray(ClassTag$.MODULE$.apply(String.class))).withJavacOptions((String[])settings.javacOptions().toArray(ClassTag$.MODULE$.apply(String.class))).withOrder(settings.compileOrder());
        Reporter reporter = settings.consoleLog().useBarebonesLogger() ? ReporterUtil.getReporter((xsbti.Logger)new BareBonesLogger(settings.consoleLog().logLevel()), (ReporterConfig)ReporterManager$.MODULE$.getDefaultReporterConfig()) : ReporterUtil.getDefault((ReporterConfig)ReporterUtil.getDefaultReporterConfig().withMaximumErrors(Integer.MAX_VALUE).withUseColor(settings.consoleLog().color()).withMsgFilters((Function[])settings.consoleLog().msgPredicates().toArray(ClassTag$.MODULE$.apply(Function.class))).withFileFilters((Function[])settings.consoleLog().filePredicates().toArray(ClassTag$.MODULE$.apply(Function.class))).withLogLevel(settings.consoleLog().javaLogLevel()).withPositionMapper((Function)positionMapper));
        Setup setup = Setup.create((PerClasspathEntryLookup)analysisMap.getPCELookup(), (boolean)false, (File)settings.analysis().cache(), (GlobalsCache)CompilerUtils$.MODULE$.getGlobalsCache(), (IncOptions)settings.incOptions().options(log), (Reporter)reporter, (Optional)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)None$.MODULE$)), (T2[])((T2[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(T2.class))));
        return Inputs.create((Compilers)compilers, (CompileOptions)compileOptions, (Setup)setup, (PreviousResult)previousResult);
    }

    public Tuple2<AnalysisStore, PreviousResult> loadDestinationAnalysis(Settings settings, AnalysisMap analysisMap, Logger log) {
        Tuple3 tuple3 = InputUtils$.liftedTree1$1(settings, log, analysisMap);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AnalysisStore analysisStore = (AnalysisStore)tuple3._1();
        Option previousAnalysis = (Option)tuple3._2();
        Option previousSetup = (Option)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)analysisStore, (Object)previousAnalysis, (Object)previousSetup);
        Tuple3 tuple33 = tuple32;
        AnalysisStore analysisStore2 = (AnalysisStore)tuple33._1();
        Option previousAnalysis2 = (Option)tuple33._2();
        Option previousSetup2 = (Option)tuple33._3();
        return new Tuple2((Object)analysisStore2, (Object)PreviousResult.create((Optional)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(previousAnalysis2)), (Optional)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(previousSetup2))));
    }

    public Seq<File> autoClasspath(File classesDirectory, Seq<File> allScalaJars, boolean javaOnly, Seq<File> classpath) {
        Seq seq;
        if (javaOnly) {
            File file = classesDirectory;
            seq = (Seq)classpath.$plus$colon((Object)file, Seq$.MODULE$.canBuildFrom());
        } else {
            Seq seq2;
            Option<InputUtils.ScalaJars> option = this.splitScala(allScalaJars, this.splitScala$default$2());
            if (option instanceof Some) {
                Some some = (Some)option;
                InputUtils.ScalaJars scalaJars = (InputUtils.ScalaJars)some.value();
                File file = classesDirectory;
                File file2 = scalaJars.library();
                seq2 = (Seq)((SeqLike)classpath.$plus$colon((Object)file2, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)file, Seq$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option)) {
                File file = classesDirectory;
                seq2 = (Seq)classpath.$plus$colon((Object)file, Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(option);
            }
            seq = seq2;
        }
        return seq;
    }

    public InputUtils.ScalaJars selectScalaJars(ScalaLocation scala) {
        InputUtils.ScalaJars jars = (InputUtils.ScalaJars)this.splitScala(scala.path(), this.splitScala$default$2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> InputUtils$Defaults$.MODULE$.scalaJars());
        return new InputUtils.ScalaJars((File)scala.compiler().getOrElse((Function0 & Serializable & scala.Serializable)() -> jars.compiler()), (File)scala.library().getOrElse((Function0 & Serializable & scala.Serializable)() -> jars.library()), (Seq<File>)((Seq)scala.extra().$plus$plus(jars.extra(), Seq$.MODULE$.canBuildFrom())));
    }

    public Option<InputUtils.ScalaJars> splitScala(Seq<File> jars, Set<String> excluded) {
        Seq filtered = (Seq)jars.filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)excluded.contains((Object)x$6.getName())));
        Tuple2 tuple2 = filtered.partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)InputUtils$.$anonfun$splitScala$2(x$7)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq compiler = (Seq)tuple2._1();
        Seq other = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)compiler, (Object)other);
        Tuple2 tuple23 = tuple22;
        Seq compiler2 = (Seq)tuple23._1();
        Seq other2 = (Seq)tuple23._2();
        Tuple2 tuple24 = other2.partition((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)InputUtils$.$anonfun$splitScala$3(x$9)));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Seq library = (Seq)tuple24._1();
        Seq extra = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)library, (Object)extra);
        Tuple2 tuple26 = tuple25;
        Seq library2 = (Seq)tuple26._1();
        Seq extra2 = (Seq)tuple26._2();
        return compiler2.nonEmpty() && library2.nonEmpty() ? new Some((Object)new InputUtils.ScalaJars((File)compiler2.apply(0), (File)library2.apply(0), (Seq<File>)extra2)) : None$.MODULE$;
    }

    public Set<String> splitScala$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public InputUtils.JarFile ScalaCompiler() {
        return this.ScalaCompiler;
    }

    public InputUtils.JarFile ScalaLibrary() {
        return this.ScalaLibrary;
    }

    public InputUtils.JarFile ScalaReflect() {
        return this.ScalaReflect;
    }

    private static final Tuple3 load$1(AnalysisMap analysisMap$1, Settings settings$1) {
        Tuple3 tuple3;
        AnalysisStore analysisStore = analysisMap$1.cachedStore(settings$1.analysis().cache());
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(analysisStore.get()));
        if (option instanceof Some) {
            Some some = (Some)option;
            AnalysisContents a = (AnalysisContents)some.value();
            tuple3 = new Tuple3((Object)analysisStore, (Object)new Some((Object)a.getAnalysis()), (Object)new Some((Object)a.getMiniSetup()));
        } else {
            tuple3 = new Tuple3((Object)analysisStore, (Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        return tuple3;
    }

    private static final Tuple3 liftedTree1$1(Settings settings$1, Logger log$1, AnalysisMap analysisMap$1) {
        Tuple3 tuple3;
        try {
            tuple3 = InputUtils$.load$1(analysisMap$1, settings$1);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            block5: {
                block4: {
                    Throwable throwable3 = throwable;
                    if (throwable3 == null) break block4;
                    throwable2 = throwable3;
                    if (settings$1.analysis().clearInvalid()) break block5;
                }
                throw throwable;
            }
            log$1.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Failed to load analysis from ").append(settings$1.analysis().cache()).append(" (").append(throwable2).append("): will execute a clean compile.").toString());
            IO$.MODULE$.delete(settings$1.analysis().cache());
            IO$.MODULE$.delete(settings$1.classesDirectory());
            Tuple3 tuple32 = InputUtils$.load$1(analysisMap$1, settings$1);
            tuple3 = tuple32;
        }
        return tuple3;
    }

    public static final /* synthetic */ boolean $anonfun$splitScala$2(File x$7) {
        return x$7.getName().matches(MODULE$.ScalaCompiler().pattern());
    }

    public static final /* synthetic */ boolean $anonfun$splitScala$3(File x$9) {
        return x$9.getName().matches(MODULE$.ScalaLibrary().pattern());
    }

    private InputUtils$() {
        MODULE$ = this;
        this.ScalaCompiler = new InputUtils.JarFile("scala-compiler", InputUtils$JarFile$.MODULE$.apply$default$2());
        this.ScalaLibrary = new InputUtils.JarFile("scala-library", InputUtils$JarFile$.MODULE$.apply$default$2());
        this.ScalaReflect = new InputUtils.JarFile("scala-reflect", InputUtils$JarFile$.MODULE$.apply$default$2());
    }
}

