/*
 * Decompiled with CFR 0.152.
 */
package org.papoose.event;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.cert.X509Certificate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.event.Event;
import org.papoose.event.EventAdminServiceFactory;

class BundleEventMapper
implements BundleListener {
    private static final String CLASS_NAME = BundleEventMapper.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private final EventAdminServiceFactory eventAdmin;

    BundleEventMapper(EventAdminServiceFactory eventAdmin) {
        assert (eventAdmin != null);
        this.eventAdmin = eventAdmin;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        String topic;
        LOGGER.entering(CLASS_NAME, "bundleChanged", bundleEvent);
        switch (bundleEvent.getType()) {
            case 1: {
                topic = "org/osgi/framework/BundleEvent/INSTALLED";
                break;
            }
            case 2: {
                topic = "org/osgi/framework/BundleEvent/STARTED";
                break;
            }
            case 4: {
                topic = "org/osgi/framework/BundleEvent/STOPPED";
                break;
            }
            case 8: {
                topic = "org/osgi/framework/BundleEvent/UPDATED";
                break;
            }
            case 16: {
                topic = "org/osgi/framework/BundleEvent/UNINSTALLED";
                break;
            }
            case 32: {
                topic = "org/osgi/framework/BundleEvent/RESOLVED";
                break;
            }
            case 64: {
                topic = "org/osgi/framework/BundleEvent/UNRESOLVED";
                break;
            }
            default: {
                return;
            }
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Bundle bundle = bundleEvent.getBundle();
        ((Dictionary)properties).put("event", bundleEvent);
        ((Dictionary)properties).put("bundle.id", bundle.getBundleId());
        if (bundle.getSymbolicName() != null) {
            ((Dictionary)properties).put("bundle.symbolicName", bundle.getSymbolicName());
        }
        if (bundle.getVersion() != null) {
            ((Dictionary)properties).put("bundle.version", bundle.getVersion());
        }
        ((Dictionary)properties).put("bundle", bundle);
        Map certificates = bundle.getSignerCertificates(1);
        if (certificates != null && !certificates.keySet().isEmpty()) {
            HashSet<String> signers = new HashSet<String>();
            for (X509Certificate certificate : certificates.keySet()) {
                signers.add(certificate.getSubjectDN().getName());
            }
            if (signers.size() == 1) {
                ((Dictionary)properties).put("bundle.signer", signers.iterator().next());
            } else {
                ((Dictionary)properties).put("bundle.signer", signers);
            }
        }
        Event event = new Event(topic, properties);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Posting event " + event);
        }
        this.eventAdmin.postEvent(event);
        LOGGER.exiting(CLASS_NAME, "bundleChanged");
    }
}

