/*
 * Decompiled with CFR 0.152.
 */
package org.papoose.event;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.TopicPermission;
import org.papoose.event.EventAdminServiceFactory;

public class SecureEventAdminServiceFactory
extends EventAdminServiceFactory {
    private static final String CLASS_NAME = SecureEventAdminServiceFactory.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);

    public SecureEventAdminServiceFactory(BundleContext context, ExecutorService executor, ScheduledExecutorService scheduledExecutor) {
        super(context, executor, scheduledExecutor);
    }

    public Object getService(final Bundle bundle, ServiceRegistration registration) {
        LOGGER.entering(CLASS_NAME, "getService", new Object[]{bundle, registration});
        EventAdmin proxy = new EventAdmin(){

            public void postEvent(Event event) {
                bundle.hasPermission((Object)new TopicPermission(event.getTopic(), "publish"));
                SecureEventAdminServiceFactory.this.postEvent(event);
            }

            public void sendEvent(Event event) {
                bundle.hasPermission((Object)new TopicPermission(event.getTopic(), "publish"));
                SecureEventAdminServiceFactory.this.sendEvent(event);
            }
        };
        LOGGER.exiting(CLASS_NAME, "getService", proxy);
        return proxy;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    protected boolean permissionCheck(EventAdminServiceFactory.EventListener listener, Event event) {
        LOGGER.entering(CLASS_NAME, "", new Object[]{listener.getReference(), event});
        boolean result = listener.getReference().getBundle().hasPermission((Object)new TopicPermission(event.getTopic(), "subscribe"));
        LOGGER.exiting(CLASS_NAME, "", result);
        return result;
    }
}

