/*
 * Decompiled with CFR 0.152.
 */
package org.papoose.event;

import java.security.Permission;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.TopicPermission;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.papoose.event.BundleEventMapper;
import org.papoose.event.FrameworkEventMapper;
import org.papoose.event.ServiceEventMapper;
import org.papoose.event.util.LogServiceTracker;
import org.papoose.event.util.SerialExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAdminServiceFactory
implements ServiceFactory {
    private static final String CLASS_NAME = EventAdminServiceFactory.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private static final Filter DEFAULT_FILTER = new Filter(){

        public boolean match(ServiceReference serviceReference) {
            return true;
        }

        public boolean match(Dictionary dictionary) {
            return true;
        }

        public boolean matchCase(Dictionary dictionary) {
            return true;
        }
    };
    private final FrameworkEventMapper frameworkEventMapper = new FrameworkEventMapper(this);
    private volatile ServiceRegistration frameworkServiceRegistration;
    private final BundleEventMapper bundleEventMapper = new BundleEventMapper(this);
    private volatile ServiceRegistration bundleServiceRegistration;
    private final ServiceEventMapper serviceEventMapper = new ServiceEventMapper(this);
    private volatile ServiceRegistration serviceServiceRegistration;
    private final Listeners listeners = new Listeners();
    private final Semaphore semaphore = new Semaphore(1);
    private final BundleContext context;
    private final ServiceTracker tracker;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutor;
    private final LogServiceTracker loggers;
    private volatile int timeout = 60;
    private volatile TimeUnit timeUnit = TimeUnit.SECONDS;

    public EventAdminServiceFactory(BundleContext context, ExecutorService executor, ScheduledExecutorService scheduledExecutor) {
        if (context == null) {
            throw new IllegalArgumentException("Bundle context is null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor service is null");
        }
        if (scheduledExecutor == null) {
            throw new IllegalArgumentException("Scheduled executor service is null");
        }
        this.context = context;
        this.tracker = new ServiceTracker(context, EventHandler.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                return EventAdminServiceFactory.this.addingService(reference);
            }

            public void modifiedService(ServiceReference reference, Object service) {
                EventAdminServiceFactory.this.modifiedService(reference, service);
            }

            public void removedService(ServiceReference reference, Object service) {
                EventAdminServiceFactory.this.removedService(reference, service);
            }
        });
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
        this.loggers = new LogServiceTracker(context);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout < 1) {
            return;
        }
        this.timeout = timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        if (timeUnit == null) {
            return;
        }
        this.timeUnit = timeUnit;
    }

    public void start() {
        this.tracker.open();
        this.loggers.open();
        this.frameworkServiceRegistration = this.context.registerService(FrameworkListener.class.getName(), (Object)this.frameworkEventMapper, null);
        this.bundleServiceRegistration = this.context.registerService(BundleListener.class.getName(), (Object)this.bundleEventMapper, null);
        this.serviceServiceRegistration = this.context.registerService(ServiceListener.class.getName(), (Object)this.serviceEventMapper, null);
    }

    public void stop() {
        this.serviceServiceRegistration.unregister();
        this.serviceServiceRegistration = null;
        this.bundleServiceRegistration.unregister();
        this.bundleServiceRegistration = null;
        this.frameworkServiceRegistration.unregister();
        this.frameworkServiceRegistration = null;
        this.tracker.close();
        this.loggers.close();
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return new EventAdmin(){

            public void postEvent(Event event) {
                EventAdminServiceFactory.this.postEvent(event);
            }

            public void sendEvent(Event event) {
                EventAdminServiceFactory.this.sendEvent(event);
            }
        };
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postEvent(Event event) {
        LOGGER.entering(CLASS_NAME, "postEvent", event);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new TopicPermission(event.getTopic(), "publish"));
        }
        try {
            this.semaphore.acquire();
            Set<EventListener> set = this.collectListeners(event);
            try {
                for (EventListener listener : set) {
                    listener.executor.execute(new TimeoutRunnable(listener, event));
                }
            }
            finally {
                this.semaphore.release();
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.WARNING, "Wait interrupted", ie);
            Thread.currentThread().interrupt();
        }
        LOGGER.exiting(CLASS_NAME, "postEvent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(Event event) {
        LOGGER.entering(CLASS_NAME, "sendEvent", event);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new TopicPermission(event.getTopic(), "publish"));
        }
        try {
            this.semaphore.acquire();
            Set<EventListener> set = this.collectListeners(event);
            CountDownLatch latch = new CountDownLatch(set.size());
            try {
                if (!set.isEmpty()) {
                    for (EventListener listener : set) {
                        this.executor.execute(new TimeoutRunnable(latch, listener, event));
                    }
                }
            }
            finally {
                this.semaphore.release();
            }
            if (!set.isEmpty()) {
                latch.await();
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.WARNING, "Wait interrupted", ie);
            Thread.currentThread().interrupt();
        }
        LOGGER.exiting(CLASS_NAME, "sendEvent");
    }

    private Object addingService(ServiceReference reference) {
        String[] topics;
        LOGGER.entering(CLASS_NAME, "addingService", reference);
        Object test = reference.getProperty("event.topics");
        if (test == null) {
            LOGGER.finest("Reference does not contain event topic, ignoring");
            LOGGER.exiting(CLASS_NAME, "addingService", null);
            return null;
        }
        if (test instanceof String) {
            topics = new String[]{(String)test};
        } else if (test instanceof String[]) {
            topics = (String[])test;
        } else {
            LOGGER.finest("Reference contains event topic that is not a String or String[], ignoring");
            LOGGER.exiting(CLASS_NAME, "addingService", null);
            return null;
        }
        EventHandler service = (EventHandler)this.context.getService(reference);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            for (String topic : topics) {
                if (service.getClass().getProtectionDomain().implies((Permission)new TopicPermission(topic, "subscribe"))) continue;
                LOGGER.finest("Service does not have permission to subscribe for topic " + topic + ", ignoring");
                LOGGER.exiting(CLASS_NAME, "addingService", null);
                return null;
            }
        }
        String[][] paths = new String[topics.length][];
        for (int i = 0; i < topics.length; ++i) {
            paths[i] = topics[i].split("/");
            for (int j = 0; j < paths[i].length - 1; ++j) {
                if ("*".equals(paths[i][j])) {
                    this.loggers.log(reference, 2, "Service has an ill formatted topic " + topics[i] + ", ignoring");
                    LOGGER.finest("Service has an ill formatted topic " + topics[i] + ", ignoring");
                    LOGGER.exiting(CLASS_NAME, "addingService", null);
                    return null;
                }
                paths[i][j] = paths[i][j].intern();
            }
            paths[i][paths[i].length - 1] = paths[i][paths[i].length - 1].intern();
        }
        String filter = (String)reference.getProperty("event.filter");
        try {
            EventListener listener = new EventListener(paths, reference, service, filter);
            this.add(listener);
            LOGGER.exiting(CLASS_NAME, "addingService", listener);
            return listener;
        }
        catch (InvalidSyntaxException e) {
            this.loggers.log(reference, 2, "Service had an invalid filter " + filter + ", ignoring", e);
            LOGGER.finest("Service had an invalid filter " + filter + ", ignoring");
            LOGGER.exiting(CLASS_NAME, "addingService", null);
            return null;
        }
    }

    private void modifiedService(ServiceReference reference, Object service) {
        LOGGER.entering(CLASS_NAME, "modifiedService", new Object[]{reference, service});
        this.removedService(reference, service);
        this.addingService(reference);
        LOGGER.exiting(CLASS_NAME, "modifiedService", null);
    }

    private void removedService(ServiceReference reference, Object service) {
        LOGGER.entering(CLASS_NAME, "removedService", new Object[]{reference, service});
        this.remove((EventListener)service);
        LOGGER.exiting(CLASS_NAME, "removedService", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(EventListener listener) {
        LOGGER.entering(CLASS_NAME, "add", listener);
        for (String[] tokens : listener.paths) {
            Listeners check;
            Object object;
            Listeners lPtr = this.listeners;
            for (int i = 0; i < tokens.length - 1; ++i) {
                object = lPtr.children;
                synchronized (object) {
                    check = (Listeners)lPtr.children.get(tokens[i]);
                    if (check == null) {
                        check = new Listeners();
                        lPtr.children.put(tokens[i], check);
                    }
                    lPtr = check;
                    continue;
                }
            }
            String token = tokens[tokens.length - 1];
            if ("*".equals(token)) {
                object = lPtr.handlers;
                synchronized (object) {
                    lPtr.wildcards.add(listener);
                    continue;
                }
            }
            object = lPtr.handlers;
            synchronized (object) {
                check = (Listeners)lPtr.children.get(token);
                if (check == null) {
                    check = new Listeners();
                    lPtr.children.put(token, check);
                }
                check.handlers.add(listener);
            }
        }
        LOGGER.exiting(CLASS_NAME, "add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(EventListener listener) {
        LOGGER.entering(CLASS_NAME, "remove", listener);
        this.context.ungetService(listener.reference);
        for (String[] tokens : listener.paths) {
            Set set;
            Listeners lPtr = this.listeners;
            for (int i = 0; i < tokens.length - 1; ++i) {
                if ((lPtr = (Listeners)lPtr.children.get(tokens[i])) != null) continue;
                return;
            }
            String token = tokens[tokens.length - 1];
            if ("*".equals(token)) {
                set = lPtr.handlers;
                synchronized (set) {
                    lPtr.wildcards.remove(listener);
                    continue;
                }
            }
            set = lPtr.handlers;
            synchronized (set) {
                Listeners check = (Listeners)lPtr.children.get(token);
                if (check == null) {
                    check = new Listeners();
                    lPtr.children.put(token, check);
                }
                check.handlers.remove(listener);
            }
        }
        LOGGER.exiting(CLASS_NAME, "remove");
    }

    private Set<EventListener> collectListeners(Event event) {
        LOGGER.entering(CLASS_NAME, "collectListeners", event);
        Listeners lPtr = this.listeners;
        HashSet<EventListener> set = new HashSet<EventListener>();
        String[] tokens = event.getTopic().split("/");
        for (int i = 0; i < tokens.length - 1; ++i) {
            this.addListeners(set, lPtr.wildcards, event);
            lPtr = (Listeners)lPtr.children.get(tokens[i]);
            if (lPtr == null) break;
        }
        if (lPtr != null) {
            this.addListeners(set, lPtr.wildcards, event);
            lPtr = (Listeners)lPtr.children.get(tokens[tokens.length - 1]);
            if (lPtr != null) {
                this.addListeners(set, lPtr.handlers, event);
            }
        }
        LOGGER.exiting(CLASS_NAME, "collectListeners", set);
        return set;
    }

    protected boolean permissionCheck(EventListener listener, Event event) {
        return true;
    }

    private void addListeners(Set<EventListener> to, Set<EventListener> from, Event event) {
        LOGGER.entering(CLASS_NAME, "addListeners", new Object[]{to, from, event});
        if (from != null) {
            for (EventListener eventListener : from) {
                if (!this.permissionCheck(eventListener, event) || !event.matches(eventListener.filter)) continue;
                to.add(eventListener);
            }
        }
        LOGGER.exiting(CLASS_NAME, "addListeners");
    }

    protected class EventListener
    implements EventHandler {
        private final Executor executor;
        private final String[][] paths;
        private final ServiceReference reference;
        private final EventHandler handler;
        private final Filter filter;

        private EventListener(String[][] paths, ServiceReference reference, EventHandler handler, String filter) throws InvalidSyntaxException {
            assert (paths != null);
            assert (reference != null);
            assert (handler != null);
            this.executor = new SerialExecutor(EventAdminServiceFactory.this.executor);
            this.paths = paths;
            this.reference = reference;
            this.handler = handler;
            this.filter = filter == null ? DEFAULT_FILTER : EventAdminServiceFactory.this.context.createFilter(filter);
        }

        public ServiceReference getReference() {
            return this.reference;
        }

        public void handleEvent(Event event) {
            this.handler.handleEvent(event);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("(");
            for (String[] path : this.paths) {
                if (builder.length() > 1) {
                    builder.append(", ");
                }
                builder.append(path[0]);
                for (int i = 1; i < path.length; ++i) {
                    builder.append("/").append(path[i]);
                }
            }
            builder.append(")");
            return this.getClass().getName() + " [paths=" + builder + " reference=" + this.reference + " filter=" + this.filter + "]";
        }
    }

    private static class Listeners {
        private final Map<String, Listeners> children = new Hashtable<String, Listeners>();
        private final Set<EventListener> handlers = new HashSet<EventListener>();
        private final Set<EventListener> wildcards = new HashSet<EventListener>();

        private Listeners() {
        }
    }

    private class TimeoutRunnable
    implements Runnable {
        private final CountDownLatch latch;
        private final EventListener listener;
        private final Event event;

        TimeoutRunnable(EventListener listener, Event event) {
            this(null, listener, event);
        }

        TimeoutRunnable(CountDownLatch latch, EventListener listener, Event event) {
            assert (listener != null);
            assert (event != null);
            this.latch = latch;
            this.listener = listener;
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ScheduledFuture<?> future = null;
            try {
                future = EventAdminServiceFactory.this.scheduledExecutor.schedule(new Runnable(){

                    public void run() {
                        EventAdminServiceFactory.this.loggers.log(TimeoutRunnable.this.listener.reference, 2, "Listener timeout, will be blacklisted");
                        LOGGER.warning("Listener timeout, " + TimeoutRunnable.this.listener.reference + " will be blacklisted");
                        EventAdminServiceFactory.this.remove(TimeoutRunnable.this.listener);
                    }
                }, (long)EventAdminServiceFactory.this.timeout, EventAdminServiceFactory.this.timeUnit);
                this.listener.handleEvent(this.event);
            }
            catch (RejectedExecutionException ree) {
                EventAdminServiceFactory.this.loggers.log(this.listener.reference, 2, "Unable to schedule timeout for listener call, call skipped", ree);
                LOGGER.log(Level.WARNING, "Unable to schedule timeout for listener call, call skipped", ree);
            }
            catch (Throwable t) {
                EventAdminServiceFactory.this.loggers.log(this.listener.reference, 2, "Listener threw exception", t);
                LOGGER.log(Level.WARNING, "Listener threw exception", t);
            }
            finally {
                if (future != null) {
                    future.cancel(false);
                }
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }

        public String toString() {
            return this.getClass().getName() + " [listener=" + this.listener + " event=" + this.event + "]";
        }
    }
}

